/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.admincenter.ConnectHomePage;
import org.nuxeo.functionaltests.pages.admincenter.SystemHomePage;
import org.nuxeo.functionaltests.pages.admincenter.UpdateCenterPage;
import org.nuxeo.functionaltests.pages.admincenter.VocabulariesPage;
import org.nuxeo.functionaltests.pages.admincenter.WorkflowsPage;
import org.nuxeo.functionaltests.pages.admincenter.activity.ActivityPage;
import org.nuxeo.functionaltests.pages.admincenter.monitoring.MonitoringPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AdminCenterBasePage
extends AbstractPage {
    @Required
    @FindBy(linkText="System Information")
    public WebElement systemInformationLink;
    @FindBy(linkText="Users & Groups")
    public WebElement userAndGroupsLink;
    @FindBy(linkText="WORKSPACE")
    public WebElement documentManagementLink;
    @FindBy(linkText="Update Center")
    public WebElement updateCenterLink;
    @FindBy(linkText="Monitoring")
    public WebElement monitoringLink;
    @FindBy(linkText="Nuxeo Online Services")
    public WebElement nuxeoConnectLink;
    @FindBy(linkText="Vocabularies")
    public WebElement vocabulariesLink;
    @FindBy(linkText="Workflow")
    public WebElement worflowsLink;
    @FindBy(linkText="Activity")
    public WebElement activityLink;

    public AdminCenterBasePage(WebDriver driver) {
        super(driver);
    }

    protected void clickOnTab(WebElement tab) {
        this.clickOnTab(tab, this.useAjaxTabs());
    }

    protected void clickOnTab(WebElement tab, boolean useAjax) {
        this.clickOnTabIfNotSelected("nxw_adminCenterTabs_panel", tab, useAjax);
    }

    public UsersGroupsBasePage getUsersGroupsHomePage() {
        this.clickOnTab(this.userAndGroupsLink);
        return this.asPage(UsersGroupsBasePage.class);
    }

    public ConnectHomePage getConnectHomePage() {
        this.clickOnTab(this.nuxeoConnectLink);
        return this.asPage(ConnectHomePage.class);
    }

    public UpdateCenterPage getUpdateCenterHomePage() {
        this.clickOnTab(this.updateCenterLink);
        return this.asPage(UpdateCenterPage.class);
    }

    public MonitoringPage getMonitoringPage() {
        this.clickOnTab(this.monitoringLink);
        return this.asPage(MonitoringPage.class);
    }

    public SystemHomePage getSystemHomePage() {
        this.clickOnTab(this.systemInformationLink);
        return this.asPage(SystemHomePage.class);
    }

    public VocabulariesPage getVocabulariesPage() {
        this.clickOnTab(this.vocabulariesLink);
        return this.asPage(VocabulariesPage.class);
    }

    public WorkflowsPage getWorkflowsPage() {
        this.clickOnTab(this.worflowsLink);
        return this.asPage(WorkflowsPage.class);
    }

    public ActivityPage getActivityPage() {
        this.clickOnTab(this.activityLink, false);
        return this.asPage(ActivityPage.class);
    }

    public String getSelectedSubTab() {
        WebElement tab = AdminCenterBasePage.findElementWithTimeout(By.xpath((String)"//div[@id='nxw_adminCenterSubTabs_panel']//li[@class='selected']//a"));
        if (tab != null) {
            return tab.getText();
        }
        return null;
    }

    public AdminCenterBasePage selectSubTab(String text) {
        WebElement tab = AdminCenterBasePage.findElementWithTimeout(By.xpath((String)("//div[@id='nxw_adminCenterSubTabs_panel']//li/form/a/span[text()='" + text + "']")));
        if (tab != null) {
            tab.click();
            return this.asPage(AdminCenterBasePage.class);
        }
        return null;
    }

    public List<String> getAvailableSubTabs() {
        List elements = this.driver.findElements(By.xpath((String)"//div[@id='nxw_adminCenterSubTabs_panel']//li/form/a/span"));
        ArrayList<String> tabs = new ArrayList<String>();
        for (WebElement el : elements) {
            tabs.add(el.getText());
        }
        return tabs;
    }

    public DocumentBasePage exitAdminCenter() {
        this.documentManagementLink.click();
        return this.asPage(DocumentBasePage.class);
    }
}

