/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.drivers;

import java.net.URL;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.nuxeo.functionaltests.drivers.DriverProvider;
import org.nuxeo.functionaltests.drivers.FirefoxDriverProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteFirefoxDriverProvider
implements DriverProvider {
    public static final String WEBDRIVER_URL = System.getProperty("webdriverURL", "http://localhost:4444/wd/hub");
    protected RemoteWebDriver driver;

    @Override
    public RemoteWebDriver init(DesiredCapabilities dc) throws Exception {
        FirefoxProfile profile = FirefoxDriverProvider.getProfile();
        JavaScriptError.addExtension((FirefoxProfile)profile);
        dc.setCapability("firefox_profile", (Object)profile);
        this.driver = new RemoteWebDriver(new URL(WEBDRIVER_URL), (Capabilities)dc);
        this.driver.setFileDetector((FileDetector)new LocalFileDetector());
        return this.driver;
    }

    @Override
    public RemoteWebDriver get() {
        return this.driver;
    }

    @Override
    public void quit() {
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
        }
    }
}

