/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.drivers;

import java.io.File;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.drivers.DriverProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class FirefoxDriverProvider
implements DriverProvider {
    private static final Log log = LogFactory.getLog(FirefoxDriverProvider.class);
    protected FirefoxDriver driver;

    public static FirefoxProfile getProfile() throws Exception {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setEnableNativeEvents(false);
        profile.setPreference("general.useragent.locale", "en");
        profile.setPreference("intl.accept_languages", "en");
        profile.setPreference("network.http.keep-alive", true);
        profile.setPreference("network.http.pipelining", true);
        profile.setPreference("network.http.proxy.pipelining", true);
        profile.setPreference("network.http.pipelining.maxrequests", 8);
        profile.setPreference("browser.sessionhistory.max_entries", 10);
        profile.setPreference("browser.sessionhistory.max_total_viewers", 4);
        profile.setPreference("browser.sessionstore.max_tabs_undo", 4);
        profile.setPreference("browser.sessionstore.interval", 1800000);
        profile.setPreference("dom.max_script_run_time", 0);
        profile.setPreference("dom.max_chrome_script_run_time", 0);
        profile.setPreference("network.proxy.no_proxies_on", "");
        profile.setPreference("browser.tabs.warnOnClose", false);
        profile.setPreference("browser.tabs.warnOnOpen", false);
        profile.setPreference("extensions.newAddons", false);
        profile.setPreference("extensions.update.notifyUser", false);
        profile.setPreference("browser.urlbar.autocomplete.enabled", false);
        profile.setPreference("browser.download.useDownloadDir", false);
        profile.setPreference("toolkit.networkmanager.disable", true);
        profile.setPreference("datareporting.policy.dataSubmissionEnabled", false);
        profile.setPreference("datareporting.healthreport.uploadEnabled", false);
        profile.setPreference("datareporting.healthreport.service.firstRun", false);
        profile.setPreference("datareporting.healthreport.service.enabled", false);
        profile.setPreference("datareporting.healthreport.logging.consoleEnabled", false);
        profile.setPreference("browser.startup.homepage", "about:blank");
        profile.setPreference("pref.browser.homepage.disable_button.bookmark_page", false);
        profile.setPreference("pref.browser.homepage.disable_button.restore_default", false);
        profile.setPreference("browser.search.update", false);
        profile.setPreference("browser.bookmarks.restore_default_bookmarks", false);
        profile.setPreference("extensions.ui.dictionary.hidden", true);
        profile.setPreference("layout.spellcheckDefault", 0);
        profile.setPreference("startup.homepage_welcome_url.additional", "about:blank");
        profile.setPreference("general.warnOnAboutConfig", false);
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getenv("nuxeo.log.webriver")))) {
            String location = System.getProperty("basedir") + File.separator + "target";
            File outputFolder = new File(location);
            if (!outputFolder.exists() || !outputFolder.isDirectory()) {
                outputFolder = null;
            }
            File webdriverlogFile = File.createTempFile("webdriver", ".log", outputFolder);
            profile.setPreference("webdriver.log.file", webdriverlogFile.getAbsolutePath());
            log.warn((Object)("Webdriver logs saved in " + webdriverlogFile));
        }
        return profile;
    }

    @Override
    public RemoteWebDriver init(DesiredCapabilities dc) throws Exception {
        FirefoxProfile profile = FirefoxDriverProvider.getProfile();
        JavaScriptError.addExtension((FirefoxProfile)profile);
        dc.setCapability("firefox_profile", (Object)profile);
        this.driver = new FirefoxDriver((Capabilities)dc);
        return this.driver;
    }

    @Override
    public RemoteWebDriver get() {
        return this.driver;
    }

    @Override
    public void quit() {
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
        }
    }
}

