/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.contentView;

import java.util.List;
import java.util.function.Function;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Assert;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.contentView.ContentViewSelectionActions;
import org.nuxeo.functionaltests.contentView.ContentViewUpperActions;
import org.nuxeo.functionaltests.contentView.PageNavigationControls;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ContentViewElement
extends WebFragmentImpl {
    private static final String SELECT_ALL_BUTTON_XPATH = "//input[@type=\"checkbox\" and @title=\"Select all / deselect all\"]";
    private static final String CHECK_BOX_XPATH = "td/input[@type=\"checkbox\"]";

    public ContentViewElement(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    protected ContentViewElement reload(String id) {
        return this.getWebFragment(By.id((String)id), ContentViewElement.class);
    }

    public ContentViewUpperActions getUpperActions() {
        return AbstractTest.getWebFragment(By.className((String)"contentViewUpperActions"), ContentViewUpperActions.class);
    }

    public ContentViewSelectionActions getSelectionActions() {
        By buttonsId = By.id((String)String.format("%s_buttons:ajax_selection_buttons", this.getContentViewType()));
        Locator.waitUntilElementPresent(buttonsId);
        return AbstractTest.getWebFragment(buttonsId, ContentViewSelectionActions.class);
    }

    public PageNavigationControls getPaginationControls() {
        return AbstractTest.getWebFragment(this.findElement(By.className((String)"pageNavigationControls")), PageNavigationControls.class);
    }

    protected WebElement getFilterInput() {
        String id = this.getContentViewId() + "_quickFilterForm:nxl_document_content_filter:nxw_search_title";
        return this.findElement(By.id((String)id));
    }

    protected WebElement getFilterButton() {
        String id = this.getContentViewId() + "_quickFilterForm:submitFilter";
        return this.findElement(By.id((String)id));
    }

    protected WebElement getClearFilterButton() {
        String id = this.getContentViewId() + "_resetFilterForm:resetFilter";
        return this.findElement(By.id((String)id));
    }

    protected String getContentViewId() {
        String id = this.getId();
        if (id.endsWith("_panel")) {
            return id.substring(0, id.length() - "_panel".length());
        }
        return id;
    }

    protected String getContentViewType() {
        return this.getContentViewId().replaceFirst("^cv_", "").replaceFirst("_\\d*$", "");
    }

    protected WebElement getResultsPanel() {
        String id = this.getContentViewId() + "_resultsPanel";
        return this.getElement().findElement(By.id((String)id));
    }

    public WebElement getActionByTitle(String title) {
        return this.getUpperActions().getActionByTitle(title);
    }

    public ContentViewElement switchToResultLayout(ResultLayout layout) {
        String id = this.getId();
        this.getUpperActions().clickOnActionByTitle(layout.title);
        return this.reload(id);
    }

    public <T extends DocumentBasePage> ContentViewElement navigation(Function<PageNavigationControls, T> nav) {
        String id = this.getId();
        nav.apply(this.getPaginationControls());
        return this.reload(id);
    }

    public List<WebElement> getItems() {
        ResultLayout layout = this.getResultLayout();
        switch (layout) {
            case THUMBNAIL: {
                return this.getResultsPanel().findElements(By.xpath((String)".//div[contains(@class,'bubbleBox')]"));
            }
        }
        return this.getResultsPanel().findElements(By.xpath((String)"(.//form)[1]//tbody//tr"));
    }

    public WebElement getItemWithTitleAndVersion(String title, String version) {
        for (WebElement item : this.getItems()) {
            String t = item.findElement(By.xpath((String)"td[3]")).getText();
            String v = item.findElement(By.xpath((String)"td[7]")).getText();
            if (!t.equals(title) || !v.equals(version)) continue;
            return item;
        }
        throw new NoSuchElementException("No item with title \"" + title + "\" and version " + version);
    }

    public void clickOnItemTitle(String title) {
        Locator.findElementWaitUntilEnabledAndClick(this.getResultsPanel(), By.linkText((String)title));
    }

    public void clickOnItemTitleAndVersion(String title, String version) {
        if (this.getResultLayout() == ResultLayout.THUMBNAIL) {
            throw new NoSuchElementException("Click on title and version doesn\"t work with thumbnails.");
        }
        WebElement item = this.getItemWithTitleAndVersion(title, version);
        Locator.findElementWaitUntilEnabledAndClick(item, By.linkText((String)title));
    }

    public void clickOnItemIndex(int index) {
        if (this.getResultLayout() == ResultLayout.THUMBNAIL) {
            throw new NoSuchElementException("Click on index doesn\"t work with thumbnails.");
        }
        Locator.waitUntilEnabledAndClick(this.getItems().get(index).findElement(By.xpath((String)"td[3]/div/a[1]")));
    }

    public boolean hasItem(String title) {
        try {
            WebElement element = this.getResultsPanel().findElement(By.linkText((String)title));
            return element != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public ContentViewElement filterDocument(String filter) {
        WebElement filterInput = this.getFilterInput();
        String id = this.getId();
        filterInput.clear();
        filterInput.sendKeys(new CharSequence[]{filter});
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        this.getFilterButton().click();
        arm.end();
        Locator.waitUntilElementPresent(By.id((String)this.getClearFilterButton().getAttribute("id")));
        return this.reload(id);
    }

    public ContentViewElement clearFilter() {
        WebElement clearFilterButton = this.getClearFilterButton();
        String id = this.getId();
        String clearFilterButtonId = clearFilterButton.getAttribute("id");
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.waitUntilEnabledAndClick(clearFilterButton);
        arm.end();
        Locator.waitUntilElementNotPresent(By.id((String)clearFilterButtonId));
        return this.reload(id);
    }

    @Deprecated
    public ContentViewElement checkByTitle(String ... titles) {
        String id = this.getId();
        List<WebElement> items = this.getItems();
        block2: for (WebElement item : items) {
            for (String title : titles) {
                try {
                    item.findElement(By.linkText((String)title));
                    AjaxRequestManager arm = new AjaxRequestManager(this.driver);
                    arm.begin();
                    Locator.findElementWaitUntilEnabledAndClick(item, By.xpath((String)CHECK_BOX_XPATH));
                    arm.end();
                    continue block2;
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        }
        return this.reload(id);
    }

    public ContentViewSelectionActions selectByTitle(String ... titles) {
        String id = this.getId();
        List<WebElement> items = this.getItems();
        block2: for (WebElement item : items) {
            for (String title : titles) {
                try {
                    item.findElement(By.linkText((String)title));
                    AjaxRequestManager arm = new AjaxRequestManager(this.driver);
                    arm.begin();
                    WebElement element = item.findElement(By.xpath((String)CHECK_BOX_XPATH));
                    org.junit.Assert.assertFalse((String)("Element with title=" + title + " is already selected"), (boolean)element.isSelected());
                    Locator.scrollAndForceClick(element);
                    arm.end();
                    continue block2;
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        }
        return this.reload(id).getSelectionActions();
    }

    public ContentViewElement unselectByTitle(String ... titles) {
        String id = this.getId();
        List<WebElement> items = this.getItems();
        block2: for (WebElement item : items) {
            for (String title : titles) {
                try {
                    item.findElement(By.linkText((String)title));
                    AjaxRequestManager arm = new AjaxRequestManager(this.driver);
                    arm.begin();
                    WebElement element = item.findElement(By.xpath((String)CHECK_BOX_XPATH));
                    org.junit.Assert.assertTrue((String)("Element with title=" + title + " is not selected"), (boolean)element.isSelected());
                    Locator.scrollAndForceClick(element);
                    arm.end();
                    continue block2;
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        }
        return this.reload(id);
    }

    @Deprecated
    public ContentViewElement checkByIndex(int ... indexes) {
        String id = this.getId();
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        for (int i : indexes) {
            arm.watchAjaxRequests();
            this.getItems().get(i).findElement(By.xpath((String)CHECK_BOX_XPATH)).click();
            arm.waitForAjaxRequests();
        }
        return this.reload(id);
    }

    public ContentViewSelectionActions selectByIndex(int ... indexes) {
        String id = this.getId();
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        for (int i : indexes) {
            arm.watchAjaxRequests();
            WebElement element = this.getItems().get(i).findElement(By.xpath((String)CHECK_BOX_XPATH));
            org.junit.Assert.assertFalse((String)("Element with id=" + i + " is already selected"), (boolean)element.isSelected());
            Locator.scrollAndForceClick(element);
            arm.waitForAjaxRequests();
        }
        return this.reload(id).getSelectionActions();
    }

    public ContentViewElement unselectByIndex(int ... indexes) {
        String id = this.getId();
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        for (int i : indexes) {
            arm.watchAjaxRequests();
            WebElement element = this.getItems().get(i).findElement(By.xpath((String)CHECK_BOX_XPATH));
            org.junit.Assert.assertTrue((String)("Element with id=" + i + " is not selected"), (boolean)element.isSelected());
            Locator.scrollAndForceClick(element);
            arm.waitForAjaxRequests();
        }
        return this.reload(id);
    }

    @Deprecated
    public ContentViewElement checkAllItems() {
        WebElement selectAll = null;
        try {
            selectAll = this.getResultsPanel().findElement(By.xpath((String)SELECT_ALL_BUTTON_XPATH));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (selectAll != null) {
            String id = this.getId();
            AjaxRequestManager arm = new AjaxRequestManager(this.driver);
            arm.begin();
            Locator.scrollAndForceClick(selectAll);
            arm.end();
            return this.reload(id);
        }
        return this;
    }

    public ContentViewSelectionActions selectAll() {
        WebElement selectAll = this.getResultsPanel().findElement(By.xpath((String)SELECT_ALL_BUTTON_XPATH));
        org.junit.Assert.assertFalse((String)"Select all Element is already selected", (boolean)selectAll.isSelected());
        String id = this.getId();
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.scrollAndForceClick(selectAll);
        arm.end();
        return this.reload(id).getSelectionActions();
    }

    public ContentViewElement unselectAll() {
        WebElement selectAll = this.getResultsPanel().findElement(By.xpath((String)SELECT_ALL_BUTTON_XPATH));
        org.junit.Assert.assertTrue((String)"Select all Element is not selected", (boolean)selectAll.isSelected());
        String id = this.getId();
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.scrollAndForceClick(selectAll);
        arm.end();
        return this.reload(id);
    }

    @Deprecated
    public WebElement getSelectionActionByTitle(String title) {
        return this.getUpperActions().getActionByTitle(title);
    }

    public ResultLayout getResultLayout() {
        WebElement element = this.getElement();
        WebElement resultsPanel = this.getResultsPanel();
        String resultLayoutSelected = ".//span[@class=\"resultLayoutSelection selected\"]/*/img[@alt=\"%s\"]";
        if (Assert.hasChild(element, By.xpath((String)String.format(resultLayoutSelected, ResultLayout.THUMBNAIL.title))) || Assert.hasChild(resultsPanel, By.xpath((String)".//div[contains(@class,'bubbleBox')]"))) {
            return ResultLayout.THUMBNAIL;
        }
        if (Assert.hasChild(element, By.xpath((String)String.format(resultLayoutSelected, ResultLayout.LISTING.title))) || Assert.hasChild(resultsPanel, By.xpath((String)".//table[@class='dataOutput']"))) {
            return ResultLayout.LISTING;
        }
        throw new IllegalStateException("Content view is not listing nor thumbnail.");
    }

    public static enum ResultLayout {
        THUMBNAIL("Thumbnail view"),
        LISTING("List view");

        private final String title;

        private ResultLayout(String title) {
            this.title = title;
        }
    }
}

