/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.Documents;
import org.nuxeo.client.objects.acl.ACE;
import org.nuxeo.client.objects.directory.DirectoryEntry;
import org.nuxeo.client.objects.operation.DocRef;
import org.nuxeo.client.objects.user.Group;
import org.nuxeo.client.objects.user.User;
import org.nuxeo.client.objects.workflow.Workflow;
import org.nuxeo.client.objects.workflow.Workflows;
import org.nuxeo.client.spi.NuxeoClientRemoteException;
import org.nuxeo.functionaltests.AbstractTest;

public class RestHelper {
    private static final NuxeoClient CLIENT = ((NuxeoClient.Builder)new NuxeoClient.Builder().url(AbstractTest.NUXEO_URL).authentication("Administrator", "Administrator").timeout(120L)).connect();
    private static final String USER_WORKSPACE_PATH_FORMAT = "/default-domain/UserWorkspaces/%s";
    private static final String DEFAULT_USER_EMAIL = "devnull@nuxeo.com";
    private static final String DOCUMENT_QUERY_BY_PATH_BASE = "SELECT * FROM Document WHERE ecm:path = '%s'";
    private static final Map<String, String> documentsToDelete = new HashMap<String, String>();
    private static final List<String> usersToDelete = new ArrayList<String>();
    private static final List<String> groupsToDelete = new ArrayList<String>();
    protected static final Map<String, Set<String>> directoryEntryIdsToDelete = new HashMap<String, Set<String>>();
    protected static final Log log = LogFactory.getLog(RestHelper.class);

    private RestHelper() {
    }

    public static void cleanup() {
        RestHelper.cleanupDocuments();
        RestHelper.cleanupUsers();
        RestHelper.cleanupGroups();
        RestHelper.cleanupDirectoryEntries();
    }

    public static void cleanupDocuments() {
        documentsToDelete.keySet().forEach(RestHelper::deleteDocument);
        documentsToDelete.clear();
    }

    public static void cleanupUsers() {
        for (String user : usersToDelete) {
            RestHelper.deleteDocument(String.format(USER_WORKSPACE_PATH_FORMAT, user));
        }
        usersToDelete.forEach(RestHelper::deleteUser);
        usersToDelete.clear();
    }

    public static void cleanupGroups() {
        groupsToDelete.forEach(RestHelper::deleteGroup);
        groupsToDelete.clear();
    }

    public static void cleanupDirectoryEntries() {
        directoryEntryIdsToDelete.forEach((directoryName, entryIds) -> entryIds.forEach(id -> RestHelper.deleteDirectoryEntry(directoryName, id)));
        RestHelper.clearDirectoryEntryIdsToDelete();
    }

    public static void addDocumentToDelete(String idOrPath) {
        Document document = RestHelper.fetchDocumentByIdOrPath(idOrPath);
        RestHelper.addDocumentToDelete(document.getId(), document.getPath());
    }

    public static void addDocumentToDelete(String id, String path) {
        if (documentsToDelete.values().stream().noneMatch(path::startsWith)) {
            documentsToDelete.put(id, path);
        }
    }

    public static void removeDocumentToDelete(String idOrPath) {
        if (idOrPath.startsWith("/")) {
            documentsToDelete.values().remove(idOrPath);
        } else {
            documentsToDelete.remove(idOrPath);
        }
    }

    public static void addUserToDelete(String userName) {
        usersToDelete.add(userName);
    }

    public static void removeUserToDelete(String userName) {
        usersToDelete.remove(userName);
    }

    public static void addGroupToDelete(String groupName) {
        groupsToDelete.add(groupName);
    }

    public static void addDirectoryEntryToDelete(String directoryName, String entryId) {
        directoryEntryIdsToDelete.computeIfAbsent(directoryName, k -> new HashSet()).add(entryId);
    }

    public static void removeDirectoryEntryToDelete(String directoryName, String entryId) {
        directoryEntryIdsToDelete.getOrDefault(directoryName, Collections.emptySet()).remove(entryId);
    }

    public static void clearDirectoryEntryIdsToDelete() {
        directoryEntryIdsToDelete.clear();
    }

    public static String createUser(String username, String password) {
        return RestHelper.createUser(username, password, null, null, null, null, null);
    }

    public static String createUser(String username, String password, String firstName, String lastName, String company, String email, String group) {
        String finalEmail = StringUtils.isBlank((CharSequence)email) ? DEFAULT_USER_EMAIL : email;
        User user = new User();
        user.setUserName(username);
        user.setPassword(password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setCompany(company);
        user.setEmail(finalEmail);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            user.setGroups(Collections.singletonList(group));
        }
        user = CLIENT.userManager().createUser(user);
        String userId = user.getId();
        usersToDelete.add(userId);
        return userId;
    }

    public static void deleteUser(String username) {
        try {
            CLIENT.userManager().deleteUser(username);
        }
        catch (NuxeoClientRemoteException e) {
            if (e.getStatus() == 404) {
                log.warn((Object)String.format("User %s not deleted because not found", username));
            }
            throw e;
        }
    }

    public static boolean userExists(String username) {
        return RestHelper.exists(() -> CLIENT.userManager().fetchUser(username));
    }

    public static void createGroup(String name, String label) {
        RestHelper.createGroup(name, label, null, null);
    }

    public static void createGroup(String name, String label, String[] members, String[] subGroups) {
        Group group = new Group();
        group.setGroupName(name);
        group.setGroupLabel(label);
        if (members != null) {
            group.setMemberUsers(Arrays.asList(members));
        }
        if (subGroups != null) {
            group.setMemberGroups(Arrays.asList(subGroups));
        }
        CLIENT.userManager().createGroup(group);
        groupsToDelete.add(name);
    }

    public static void deleteGroup(String name) {
        try {
            CLIENT.userManager().deleteGroup(name);
        }
        catch (NuxeoClientRemoteException e) {
            if (e.getStatus() == 404) {
                log.warn((Object)String.format("Group %s not deleted because not found", name));
            }
            throw e;
        }
    }

    public static boolean groupExists(String groupName) {
        return RestHelper.exists(() -> CLIENT.userManager().fetchGroup(groupName));
    }

    public static String createDocument(String idOrPath, String type, String title) {
        return RestHelper.createDocument(idOrPath, type, title, Collections.emptyMap());
    }

    public static String createDocument(String idOrPath, String type, String title, String description) {
        Map<Object, Object> props = description == null ? Collections.emptyMap() : Collections.singletonMap("dc:description", description);
        return RestHelper.createDocument(idOrPath, type, title, props);
    }

    public static String createDocument(String idOrPath, String type, String title, Map<String, Object> props) {
        Document document = Document.createWithName((String)title, (String)type);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (props != null) {
            properties.putAll(props);
        }
        properties.put("dc:title", title);
        document.setProperties(properties);
        document = idOrPath.startsWith("/") ? CLIENT.repository().createDocumentByPath(idOrPath, document) : CLIENT.repository().createDocumentById(idOrPath, document);
        String docId = document.getId();
        String docPath = document.getPath();
        RestHelper.addDocumentToDelete(docId, docPath);
        return docId;
    }

    public static void deleteDocument(String idOrPath) {
        if (idOrPath.startsWith("/")) {
            Documents documents = CLIENT.repository().query(String.format(DOCUMENT_QUERY_BY_PATH_BASE, idOrPath));
            if (documents.size() > 0) {
                CLIENT.repository().deleteDocument(documents.getDocument(0));
            }
        } else {
            CLIENT.repository().deleteDocument(idOrPath);
        }
    }

    public static void addPermission(String idOrPath, String username, String permission) {
        ACE ace = new ACE();
        ace.setUsername(username);
        ace.setPermission(permission);
        RestHelper.fetchDocumentByIdOrPath(idOrPath).addPermission(ace);
    }

    public static void removePermissions(String idOrPath, String username) {
        RestHelper.fetchDocumentByIdOrPath(idOrPath).removePermission(username);
    }

    public static void followLifecycleTransition(String idOrPath, String transitionName) {
        CLIENT.operation("Document.FollowLifecycleTransition").input((Object)new DocRef(idOrPath)).param("value", (Object)transitionName).execute();
    }

    public static boolean documentExists(String idOrPath) {
        return RestHelper.exists(() -> RestHelper.fetchDocumentByIdOrPath(idOrPath));
    }

    public static void startWorkflowInstance(String idOrPath, String workflowId) {
        Workflow workflow = CLIENT.repository().fetchWorkflowModel(workflowId);
        if (idOrPath.startsWith("/")) {
            CLIENT.repository().startWorkflowInstanceWithDocPath(idOrPath, workflow);
        } else {
            CLIENT.repository().startWorkflowInstanceWithDocId(idOrPath, workflow);
        }
    }

    public static boolean documentHasWorkflowStarted(String idOrPath) {
        Workflows workflows = idOrPath.startsWith("/") ? CLIENT.repository().fetchWorkflowInstancesByDocPath(idOrPath) : CLIENT.repository().fetchWorkflowInstancesByDocId(idOrPath);
        return workflows.size() > 0;
    }

    public static String getWorkflowInstanceTitle(String workflowId) {
        Workflow workflow = CLIENT.repository().fetchWorkflowModel(workflowId);
        return workflow.getTitle();
    }

    protected static Document fetchDocumentByIdOrPath(String idOrPath) {
        if (idOrPath.startsWith("/")) {
            return CLIENT.repository().fetchDocumentByPath(idOrPath);
        }
        return CLIENT.repository().fetchDocumentById(idOrPath);
    }

    public static int countQueryPageProvider(String providerName) {
        Documents result = CLIENT.repository().queryByProvider(providerName, "1", "0", "-1", "dc:title", "ASC", null);
        return result.getTotalSize();
    }

    public static String createDirectoryEntry(String directoryName, Map<String, String> properties) {
        DirectoryEntry entry = new DirectoryEntry();
        entry.setProperties(properties);
        entry = CLIENT.directoryManager().directory(directoryName).createEntry(entry);
        String entryId = entry.getId();
        RestHelper.addDirectoryEntryToDelete(directoryName, entryId);
        return entryId;
    }

    public static Map<String, Object> fetchDirectoryEntryProperties(String directoryName, String entryId) {
        return CLIENT.directoryManager().directory(directoryName).fetchEntry(entryId).getProperties();
    }

    public static void updateDirectoryEntry(String directoryName, String entryId, Map<String, String> properties) {
        DirectoryEntry entry = new DirectoryEntry();
        entry.setProperties(properties);
        entry.putIdProperty((Object)entryId);
        CLIENT.directoryManager().directory(directoryName).updateEntry(entry);
    }

    public static void deleteDirectoryEntry(String directoryName, String entryId) {
        CLIENT.directoryManager().directory(directoryName).deleteEntry(entryId);
    }

    public static void deleteDirectoryEntries(String directoryName) {
        CLIENT.directoryManager().directory(directoryName).fetchEntries().getDirectoryEntries().forEach(entry -> {
            entry.delete();
            RestHelper.removeDirectoryEntryToDelete(directoryName, entry.getId());
        });
    }

    public static void operation(String operationId, Map<String, Object> parameters) {
        CLIENT.operation(operationId).parameters(parameters).execute();
    }

    public static void logOnServer(String message) {
        RestHelper.logOnServer("warn", message);
    }

    public static void logOnServer(String level, String message) {
        RestHelper.logOnServer("RestHelper", level, message);
    }

    public static void logOnServer(String source, String level, String message) {
        CLIENT.operation("Log").param("category", (Object)RestHelper.class.getName()).param("level", (Object)level).param("message", (Object)String.format("----- %s: %s", source, message)).execute();
    }

    public static boolean get(String path) {
        return RestHelper.executeHTTP(() -> CLIENT.get(AbstractTest.NUXEO_URL + path));
    }

    public static boolean post(String path, String body) {
        return RestHelper.executeHTTP(() -> CLIENT.post(AbstractTest.NUXEO_URL + path, body));
    }

    protected static boolean executeHTTP(Supplier<Response> fetcher) {
        Response response = fetcher.get();
        response.body().close();
        return response.isSuccessful();
    }

    protected static <T> boolean exists(Supplier<T> fetcher) {
        try {
            return fetcher.get() != null;
        }
        catch (NuxeoClientRemoteException nce) {
            if (nce.getStatus() == 404) {
                return false;
            }
            throw nce;
        }
    }
}

