/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.junit.Assert;
import org.openqa.selenium.WebDriver;

public class JavaScriptErrorCollector {
    protected final WebDriver driver;
    protected List<JavaScriptErrorIgnoreRule> ignores;

    public JavaScriptErrorCollector(WebDriver driver) {
        this.driver = driver;
        this.ignores = new ArrayList<JavaScriptErrorIgnoreRule>();
        this.ignore(JavaScriptErrorIgnoreRule.startsWith("mutating the [[Prototype]] of an object"));
    }

    public static JavaScriptErrorCollector from(WebDriver driver) {
        return new JavaScriptErrorCollector(driver);
    }

    public JavaScriptErrorCollector ignore(JavaScriptErrorIgnoreRule ... ignores) {
        this.ignores.addAll(Arrays.asList(ignores));
        return this;
    }

    public void checkForErrors() {
        if (this.driver == null) {
            return;
        }
        List jsErrors = JavaScriptError.readErrors((WebDriver)this.driver);
        if (jsErrors != null && !jsErrors.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            int i = 0;
            for (JavaScriptError jsError : jsErrors) {
                if (this.ignores.stream().anyMatch(e -> e.isIgnored(jsError))) continue;
                if (i != 0) {
                    msg.append(", ");
                }
                ++i;
                msg.append("\"").append(jsError.getErrorMessage()).append("\"");
                msg.append(" at ").append(jsError.getSourceName());
                msg.append(" line ").append(jsError.getLineNumber());
            }
            if (i > 0) {
                msg.append("]");
                msg.insert(0, jsErrors.size() + " Javascript error(s) detected: [");
                Assert.fail((String)msg.toString());
            }
        }
    }

    public static class JavaScriptErrorIgnoreRule {
        protected String text = "";
        protected String source = "";

        protected JavaScriptErrorIgnoreRule(String text) {
            this.text = text;
        }

        protected boolean isIgnored(JavaScriptError error) {
            if (error.getErrorMessage().startsWith(this.text)) {
                return error.getSourceName().startsWith(this.source);
            }
            return false;
        }

        public JavaScriptErrorIgnoreRule withSource(String source) {
            this.source = source;
            return this;
        }

        public static JavaScriptErrorIgnoreRule startsWith(String text) {
            return new JavaScriptErrorIgnoreRule(text);
        }

        public static JavaScriptErrorIgnoreRule fromSource(String source) {
            return new JavaScriptErrorIgnoreRule("").withSource(source);
        }
    }
}

