/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.base.Function;
import org.nuxeo.functionaltests.Locator;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;

public class AjaxRequestManager {
    protected JavascriptExecutor js;
    protected boolean active;
    protected int count;

    public AjaxRequestManager(WebDriver driver) {
        this.js = (JavascriptExecutor)driver;
        this.reset();
    }

    protected void reset() {
        this.active = false;
        this.count = 0;
    }

    public void begin() {
        StringBuilder sb = new StringBuilder();
        sb.append("if (window.ajaxListenerSet === undefined) {");
        sb.append("window.ajaxListenerSet = true;");
        sb.append("window.NuxeoTestFaces = function() {");
        sb.append("  var e = {};");
        sb.append("  e.jsf2AjaxRequestStarted = false;");
        sb.append("  e.jsf2AjaxRequestFinished = false;");
        sb.append("  e.jsf2AjaxRequestActiveCount = 0;");
        sb.append("  e.increment = function() {");
        sb.append("    e.jsf2AjaxRequestStarted = true;");
        sb.append("    e.jsf2AjaxRequestFinished = false;");
        sb.append("    e.jsf2AjaxRequestActiveCount++;");
        sb.append("  };");
        sb.append("  e.decrement = function() {");
        sb.append("    e.jsf2AjaxRequestActiveCount--;");
        sb.append("    if (e.jsf2AjaxRequestActiveCount == 0) {");
        sb.append("      e.jsf2AjaxRequestFinished = true;");
        sb.append("    }");
        sb.append("  };");
        sb.append("  e.finished = function() {");
        sb.append("    return e.jsf2AjaxRequestStarted && e.jsf2AjaxRequestFinished;");
        sb.append("  };");
        sb.append(" return e");
        sb.append("}();");
        sb.append("if (typeof jsf !== 'undefined') {");
        sb.append("  jsf.ajax.addOnEvent(function(e) {if (e.status == 'begin') {window.NuxeoTestFaces.increment();}if (e.status == 'success') {window.NuxeoTestFaces.decrement();}})");
        sb.append("}");
        sb.append("}");
        this.js.executeScript(sb.toString(), new Object[0]);
    }

    public void watchAjaxRequests() {
        this.begin();
    }

    public void end() {
        this.waitUntil(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                Boolean res = (Boolean)AjaxRequestManager.this.js.executeScript("return window.NuxeoTestFaces.finished();", new Object[0]);
                return res;
            }
        });
    }

    public void waitForAjaxRequests() {
        this.end();
    }

    public void waitForJQueryRequests() {
        this.waitUntil(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                Boolean res = (Boolean)((JavascriptExecutor)driver).executeScript("return jQuery.active == 0;", new Object[0]);
                return res;
            }
        });
    }

    public void waitForJsClient() {
        this.waitUntil(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                StringBuilder sb = new StringBuilder();
                sb.append("if (window.isNxJsClientActive === undefined) {");
                sb.append("  window.isNxJsClientActive=function() {");
                sb.append("    var result=false;");
                sb.append("    jQuery('nuxeo-connection').each(function() {");
                sb.append("      if(this.active){return result=true;}");
                sb.append("    });");
                sb.append("    return result;");
                sb.append("  }");
                sb.append("};");
                sb.append("return window.isNxJsClientActive();");
                Boolean res = (Boolean)((JavascriptExecutor)driver).executeScript(sb.toString(), new Object[0]);
                return res == false;
            }
        });
    }

    private void waitUntil(Function<WebDriver, Boolean> function) {
        Locator.waitUntilGivenFunctionIgnoring(function, NoSuchElementException.class);
    }
}

