/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.search.backend.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.search.api.backend.impl.AbstractSearchEngineBackend;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.indexing.session.SearchServiceSession;
import org.nuxeo.ecm.core.search.api.client.query.ComposedNXQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQueryString;
import org.nuxeo.ecm.core.search.api.client.query.QueryException;
import org.nuxeo.ecm.core.search.api.client.query.SearchPrincipal;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.DocumentModelResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.ResultSetImpl;
import org.nuxeo.runtime.api.Framework;

public class CoreSearchBackend
extends AbstractSearchEngineBackend {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreSearchBackend.class);

    public SearchServiceSession createSession() {
        throw new UnsupportedOperationException();
    }

    public void closeSession(String sid) {
        throw new UnsupportedOperationException();
    }

    public void saveAllSessions() {
    }

    public void clear() throws IndexingException {
        throw new UnsupportedOperationException();
    }

    public void index(ResolvedResources resources) {
    }

    public void deleteAggregatedResources(String key) {
    }

    public void deleteAtomicResource(String key) {
    }

    public ResultSet searchQuery(NativeQueryString queryString, int offset, int range) throws QueryException {
        throw new QueryException("Native query not implemented");
    }

    public ResultSet searchQuery(NativeQuery nativeQuery, int offset, int range) throws QueryException {
        throw new QueryException("Native query not implemented");
    }

    public ResultSet searchQuery(ComposedNXQuery nxQuery, int offset, int limit) throws SearchException {
        CoreSession session;
        SearchPrincipal searchPrincipal = nxQuery.getSearchPrincipal();
        Serializable principal = CoreSearchBackend.getPrincipal(searchPrincipal);
        try {
            Repository repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository();
            if (repository == null) {
                throw new ClientException("Cannot get default repository");
            }
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("principal", principal);
            session = repository.open(context);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        try {
            ResultSet e = this.searchQuery(nxQuery.getQuery(), offset, limit, session, searchPrincipal);
            return e;
        }
        catch (ClientException e) {
            throw new SearchException((Throwable)e);
        }
        finally {
            try {
                Repository.close((CoreSession)session);
            }
            catch (Exception e) {
                throw new SearchException((Throwable)e);
            }
        }
    }

    protected ResultSet searchQuery(SQLQuery sqlQuery, int offset, int limit, CoreSession session, SearchPrincipal searchPrincipal) throws ClientException {
        String query = sqlQuery.toString();
        DocumentModelList documentModelList = session.query(query, null, (long)limit, (long)offset, true);
        int totalHits = (int)documentModelList.totalSize();
        int pageHits = documentModelList.size();
        ArrayList<DocumentModelResultItem> resultItems = new ArrayList<DocumentModelResultItem>(pageHits);
        for (DocumentModel doc : documentModelList) {
            if (doc == null) {
                log.error((Object)("Got null document from query: " + query));
                continue;
            }
            try {
                ((DocumentModelImpl)doc).detach(true);
            }
            catch (DocumentSecurityException e) {
                continue;
            }
            resultItems.add(new DocumentModelResultItem(doc));
        }
        return new ResultSetImpl(sqlQuery, searchPrincipal, offset, limit, resultItems, totalHits, pageHits);
    }

    protected static Serializable getPrincipal(SearchPrincipal searchPrincipal) {
        if (searchPrincipal == null) {
            return new UserPrincipal("system", null, false, true);
        }
        Serializable originalPrincipal = searchPrincipal.getOriginalPrincipal();
        if (originalPrincipal != null) {
            return originalPrincipal;
        }
        return new UserPrincipal(searchPrincipal.getName(), Arrays.asList(searchPrincipal.getGroups()), false, searchPrincipal.isAdministrator());
    }
}

