/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentReader;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;

public class XMLZipReader
extends AbstractDocumentReader {
    private ZipFile zip;

    public XMLZipReader(ZipFile zip) {
        this.zip = zip;
    }

    public XMLZipReader(String source) throws IOException {
        this(new ZipFile(source));
    }

    public XMLZipReader(File source) throws IOException {
        this(new ZipFile(source));
    }

    public ExportedDocument read() throws IOException {
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory()) continue;
            return this.createDocument(entry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.zip = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportedDocument createDocument(ZipEntry dirEntry) throws IOException {
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        String dirPath = dirEntry.getName();
        xdoc.setPath(new Path(dirPath).removeTrailingSeparator());
        ZipEntry entry = this.zip.getEntry(dirPath + "document.xml");
        InputStream in = this.zip.getInputStream(entry);
        try {
            Document doc = this.readXML(in);
            doc.setDocument(doc);
        }
        finally {
            in.close();
        }
        return null;
    }

    public Document readXML(InputStream in) {
        return null;
    }
}

