/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jbpm.event;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.jbpm.CreateTask;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.runtime.api.Framework;

public class TaskEndedEventListener
implements EventListener {
    private static final Log log = LogFactory.getLog(TaskEndedEventListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext eventContext = event.getContext();
        TaskInstance task = (TaskInstance)eventContext.getProperty("taskInstance");
        if (task == null) {
            return;
        }
        Boolean validated = Boolean.valueOf((String)task.getVariable(JbpmService.TaskVariableName.validated.name()));
        String chain = validated != false ? (String)task.getVariable(CreateTask.OperationTaskVariableName.acceptOperationChain.name()) : (String)task.getVariable(CreateTask.OperationTaskVariableName.rejectOperationChain.name());
        if (!StringUtils.isEmpty((String)chain)) {
            try {
                AutomationService os = (AutomationService)Framework.getService(AutomationService.class);
                OperationContext ctx = new OperationContext(eventContext.getCoreSession());
                if (eventContext instanceof DocumentEventContext) {
                    ctx.setInput((Object)((DocumentEventContext)eventContext).getSourceDocument());
                }
                try {
                    os.run(ctx, chain);
                }
                catch (InvalidChainException e) {
                    log.error((Object)("Unknown chain: " + chain));
                }
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
    }
}

