/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.search.results.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.core.search.api.client.common.TypeManagerServiceDelegate;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.client.search.results.document.ExtendedStringSource;
import org.nuxeo.ecm.core.search.api.client.search.results.document.impl.ResultDocumentModel;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.DocumentModelResultItem;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class SearchPageProvider
implements PagedDocumentsProvider {
    public static final String BLOB_DATA_KEY = "data";
    public static final String BLOB_URI_KEY = "uri";
    public static final String BLOB_ENCODING_KEY = "encoding";
    public static final String BLOB_MIMETYPE_KEY = "mime-type";
    public static final String BLOB_DIGEST_KEY = "digest";
    public static final String BLOB_NAME_KEY = "name";
    public static final String BLOB_LENGTH_KEY = "length";
    private static final long serialVersionUID = 4391326971391218440L;
    private static final Log log = LogFactory.getLog(SearchPageProvider.class);
    private static final DocumentModelList EMPTY = new DocumentModelListImpl();
    private static final Map<String, String> prefix2SchemaNameCache = new HashMap<String, String>();
    private ResultSet searchResults;
    private final String query;
    private transient Map<String, String> schemaCache;
    private DocumentModelList currentPageDocList;
    private transient SearchService service;
    private String providerName;
    private SortInfo sortInfo;
    private boolean sortable;
    private boolean pendingRefresh = false;
    private boolean pageChanged = false;
    private transient SchemaManager typeManager;

    public SearchPageProvider(ResultSet set, boolean sortable, SortInfo sortInfo, String query) {
        this.searchResults = set;
        this.sortInfo = sortInfo;
        this.sortable = sortable;
        this.query = query;
        this.initSearchService();
        this.schemaCache = new HashMap<String, String>();
    }

    public SearchPageProvider(ResultSet set) {
        this(set, false, null, null);
    }

    private void initSearchService() {
        if (this.service != null) {
            return;
        }
        try {
            this.service = SearchServiceDelegate.getRemoteSearchService();
        }
        catch (NullPointerException e) {
            this.service = null;
        }
    }

    public DocumentModelList getCurrentPage() {
        if (this.currentPageDocList != null) {
            return this.currentPageDocList;
        }
        try {
            if (this.pendingRefresh && !this.pageChanged) {
                this.performRefresh();
            }
            this.currentPageDocList = this.constructDocumentModels();
            return this.currentPageDocList;
        }
        catch (SearchException e) {
            log.error((Object)"Catched a SearchException", (Throwable)e);
            return EMPTY;
        }
    }

    public int getCurrentPageIndex() {
        int pag = this.searchResults.getPageNumber();
        return pag - 1;
    }

    public String getCurrentPageStatus() {
        int total = this.getNumberOfPages();
        int current = this.getCurrentPageIndex() + 1;
        if (total == -1) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    public DocumentModelList getNextPage() {
        this.next();
        return this.getCurrentPage();
    }

    public void goToPage(int page) {
        ++page;
        try {
            ResultSet res = this.searchResults.goToPage(page);
            if (res == null) {
                return;
            }
            this.searchResults = res;
            this.currentPageDocList = null;
            this.pageChanged = true;
        }
        catch (SearchException e) {
            log.error((Object)"getPage failed", (Throwable)e);
        }
    }

    public DocumentModelList getPage(int page) {
        this.goToPage(page);
        return this.getCurrentPage();
    }

    public long getResultsCount() {
        return this.searchResults.getTotalHits();
    }

    public boolean isNextPageAvailable() {
        return this.searchResults.hasNextPage();
    }

    public String getQuery() {
        return this.query;
    }

    public void last() {
        this.goToPage(this.getNumberOfPages() - 1);
    }

    public void next() {
        if (this.isNextPageAvailable()) {
            this.goToPage(this.getCurrentPageIndex() + 1);
        }
    }

    public void previous() {
        int i = this.getCurrentPageIndex();
        if (i > 0) {
            this.goToPage(i - 1);
        }
    }

    public void rewind() {
        this.goToPage(0);
    }

    public boolean isPreviousPageAvailable() {
        return this.getCurrentPageIndex() > 0;
    }

    public int getNumberOfPages() {
        int range = this.searchResults.getRange();
        if (range == 0) {
            return 1;
        }
        return (int)(1L + (this.getResultsCount() - 1L) / (long)range);
    }

    protected void performRefresh() throws SearchException {
        this.searchResults = this.searchResults.replay();
        this.pendingRefresh = false;
    }

    public void refresh() {
        this.pendingRefresh = true;
        this.currentPageDocList = null;
    }

    public int getCurrentPageOffset() {
        return this.searchResults.getOffset();
    }

    public int getCurrentPageSize() {
        return this.searchResults.getPageHits();
    }

    public int getPageSize() {
        return this.searchResults.getRange();
    }

    private String getSchemaNameForField(String key) {
        String schema = null;
        if (this.schemaCache == null) {
            this.schemaCache = new HashMap<String, String>();
        } else {
            schema = this.schemaCache.get(key);
        }
        if (schema != null) {
            return schema;
        }
        int cut = key.indexOf(58);
        if (cut == -1) {
            return null;
        }
        schema = this.getSchemaByPrefix(key.substring(0, cut));
        this.schemaCache.put(key, schema);
        return schema;
    }

    protected String getSchemaByPrefix(String prefix) {
        if (prefix2SchemaNameCache.containsKey(prefix)) {
            return prefix2SchemaNameCache.get(prefix);
        }
        this.initSearchService();
        IndexableResourceConf conf = this.service.getIndexableResourceConfByPrefix(prefix, true);
        if (conf == null || !conf.getType().equals("schema")) {
            prefix2SchemaNameCache.put(prefix, null);
            return null;
        }
        String schemaName = conf.getName();
        prefix2SchemaNameCache.put(prefix, schemaName);
        return schemaName;
    }

    protected DocumentModelList constructDocumentModels() {
        if (this.searchResults == null) {
            return EMPTY;
        }
        int pageHits = this.searchResults.getPageHits();
        ArrayList<DocumentModel> res = new ArrayList<DocumentModel>(pageHits);
        for (int i = 0; i < pageHits; ++i) {
            try {
                res.add(this.constructDocumentModel((ResultItem)this.searchResults.get(i)));
                continue;
            }
            catch (SearchException e) {
                log.error((Object)"Could not convert result item in DocumentModel");
            }
        }
        this.pageChanged = false;
        return new DocumentModelListImpl(res);
    }

    private DocumentModel constructDocumentModel(ResultItem rItem) throws SearchException {
        DocumentModel doc;
        if (rItem instanceof DocumentModelResultItem && (doc = ((DocumentModelResultItem)rItem).getDocumentModel()) != null) {
            return doc;
        }
        HashMap dataModels = new HashMap();
        for (String key : rItem.keySet()) {
            int cut = key.indexOf(58);
            if (cut == -1) continue;
            String fName = key.substring(cut + 1);
            String schema = this.getSchemaNameForField(key);
            if (schema == null) continue;
            HashMap<String, Object> dm = (HashMap<String, Object>)dataModels.get(schema);
            if (dm == null) {
                dm = new HashMap<String, Object>();
                dataModels.put(schema, dm);
            }
            Object value = rItem.get(key);
            Field field = this.getSchemaField(schema, fName);
            dm.put(fName, SearchPageProvider.blobFilter(value, field));
        }
        DocumentRef docRef = (DocumentRef)rItem.get("ecm:id");
        if (docRef == null) {
            throw new SearchException("Document Ref is null");
        }
        String id = docRef.toString();
        Set schemasSet = dataModels.keySet();
        String[] schemas = new String[schemasSet.size()];
        dataModels.keySet().toArray(schemas);
        List facetsList = (List)rItem.get("ecm:mixinType");
        if (facetsList == null) {
            facetsList = Collections.emptyList();
        }
        HashSet<String> facets = new HashSet<String>(facetsList);
        facets.add("immutable");
        Long flags = 0L;
        try {
            flags = (Long)rItem.get("ecm:flags");
            if (flags == null) {
                flags = 0L;
            }
        }
        catch (ClassCastException cce) {
            log.warn((Object)("Wrong value for flags..." + flags));
        }
        String path = (String)rItem.get("ecm:path");
        if (path == null) {
            path = "/";
        }
        ResultDocumentModel docModel = new ResultDocumentModel((String)rItem.get("ecm:primaryType"), id, new Path(path), docRef, (DocumentRef)rItem.get("ecm:parentId"), schemas, facets, (String)rItem.get("ecm:currentLifeCycleState"), (String)rItem.get("ecm:versionLabel"), (String)rItem.get("ecm:repositoryName"), flags);
        for (String s : dataModels.keySet()) {
            docModel.addDataModel((DataModel)new DataModelImpl(s, (Map)dataModels.get(s)));
        }
        return docModel;
    }

    protected Field getSchemaField(String schemaName, String fieldName) {
        return this.getTypeManager().getSchema(schemaName).getField(fieldName);
    }

    protected SchemaManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = TypeManagerServiceDelegate.getRemoteTypeManagerService();
        }
        return this.typeManager;
    }

    private static Object blobFilter(Object value, Field field) throws SearchException {
        if (value == null || field == null) {
            return value;
        }
        Type fieldType = field.getType();
        if (fieldType instanceof ComplexType && value instanceof Map) {
            Map map = (Map)value;
            if (TypeConstants.isContentType((Type)fieldType)) {
                int length;
                String data = (String)map.get(BLOB_DATA_KEY);
                String mimetype = (String)map.get(BLOB_MIMETYPE_KEY);
                String digest = (String)map.get(BLOB_DIGEST_KEY);
                String name = (String)map.get(BLOB_NAME_KEY);
                String lengthS = (String)map.get(BLOB_LENGTH_KEY);
                int n = length = lengthS == null ? 0 : Integer.parseInt(lengthS);
                if (mimetype == null) {
                    mimetype = "application/octet-stream";
                }
                ExtendedStringSource src = new ExtendedStringSource(data == null ? "" : data, length);
                StreamingBlob blob = new StreamingBlob((StreamSource)src, mimetype);
                blob.setEncoding((String)map.get(BLOB_ENCODING_KEY));
                blob.setDigest(digest == null ? "" : digest);
                blob.setFilename(name == null ? "" : name);
                return blob;
            }
            if (TypeConstants.isExternalContentType((Type)fieldType)) {
                String uri = (String)map.get(BLOB_URI_KEY);
                String mimetype = (String)map.get(BLOB_MIMETYPE_KEY);
                String digest = (String)map.get(BLOB_DIGEST_KEY);
                String name = (String)map.get(BLOB_NAME_KEY);
                if (mimetype == null) {
                    mimetype = "application/octet-stream";
                }
                try {
                    BlobHolderAdapterService service = (BlobHolderAdapterService)Framework.getService(BlobHolderAdapterService.class);
                    if (service == null) {
                        throw new SearchException("BlobHolderAdapterService not found");
                    }
                    Blob blob = service.getExternalBlobForUri(uri);
                    blob.setEncoding((String)map.get(BLOB_ENCODING_KEY));
                    blob.setDigest(digest == null ? "" : digest);
                    blob.setFilename(name == null ? "" : name);
                    return blob;
                }
                catch (Exception e) {
                    throw new SearchException(e);
                }
            }
            ComplexType cFieldType = (ComplexType)fieldType;
            HashMap<String, Object> filteredMap = new HashMap<String, Object>();
            for (String key : map.keySet()) {
                filteredMap.put(key, SearchPageProvider.blobFilter(map.get(key), cFieldType.getField(key)));
            }
            return filteredMap;
        }
        if (fieldType instanceof ListType && value instanceof Collection) {
            ListType lFieldType = (ListType)fieldType;
            Collection values = (Collection)value;
            ArrayList<Object> blobFilteredValues = new ArrayList<Object>(values.size());
            for (Object subValue : values) {
                blobFilteredValues.add(SearchPageProvider.blobFilter(subValue, lFieldType.getField()));
            }
            return blobFilteredValues.toArray();
        }
        return value;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public String getName() {
        return this.providerName;
    }

    public void setName(String name) {
        this.providerName = name;
    }
}

