/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.querymodel.descriptor;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.Escaper;
import org.nuxeo.ecm.core.search.api.client.querymodel.LuceneMinimalEscaper;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.PredicateDescriptor;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="whereClause")
public class WhereClauseDescriptor {
    private static final Log log = LogFactory.getLog(WhereClauseDescriptor.class);
    @XNode(value="@escaper")
    protected String escaperClassName = "org.nuxeo.ecm.core.search.api.client.querymodel.LuceneMinimalEscaper";
    @XNodeList(value="predicate", componentType=PredicateDescriptor.class, type=PredicateDescriptor[].class)
    protected PredicateDescriptor[] predicates;
    protected String fixedPart;
    protected Escaper escaper = new LuceneMinimalEscaper();

    @XNode(value="fixedPart")
    public void setFixedPath(String fixedPart) {
        this.fixedPart = fixedPart.replaceAll("\r?\n\\s*", " ");
    }

    public PredicateDescriptor[] getPredicates() {
        return this.predicates;
    }

    public void setPredicates(PredicateDescriptor[] predicates) {
        this.predicates = predicates;
    }

    public String getQueryElement(DocumentModel model) throws ClientException {
        ArrayList<String> elements = new ArrayList<String>();
        if (this.predicates != null) {
            for (PredicateDescriptor predicate : this.predicates) {
                String predicateString = predicate.getQueryElement(model, this.escaper);
                if (predicateString == null || (predicateString = predicateString.trim()).equals("")) continue;
                elements.add(predicateString);
            }
        }
        if (this.fixedPart != null && !this.fixedPart.equals("")) {
            if (elements.isEmpty()) {
                elements.add(this.fixedPart.trim());
            } else {
                elements.add('(' + this.fixedPart.trim() + ')');
            }
        }
        if (elements.isEmpty()) {
            return "";
        }
        String clauseValues = StringUtils.join(elements, (String)" AND ").trim();
        while (elements.size() == 1 && clauseValues.startsWith("(") && clauseValues.endsWith(")")) {
            clauseValues = clauseValues.substring(1, clauseValues.length() - 1).trim();
        }
        if (clauseValues.length() == 0) {
            return "";
        }
        return " WHERE " + clauseValues;
    }

    public void initEscaper(RuntimeContext context) {
        try {
            this.escaper = (Escaper)context.loadClass(this.escaperClassName).newInstance();
        }
        catch (InstantiationException e) {
            log.warn((Object)("Could not instantiate esacper: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Could not instantiate escaper: " + e.getMessage()));
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("escaper class " + this.escaperClassName + "not found"));
        }
    }

    public String getFixedPart() {
        return this.fixedPart;
    }

    public void setFixedPart(String fixedPart) {
        this.fixedPart = fixedPart;
    }
}

