/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.querymodel.descriptor;

import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.Escaper;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FieldDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;

@XObject(value="predicate")
public class PredicateDescriptor {
    private static final String ATOMIC_PREDICATE = "atomic";
    private static final String SUB_CLAUSE_PREDICATE = "subClause";
    private static final String STATIC_PREDICATE = "static";
    @XNode(value="@parameter")
    protected String parameter;
    @XNode(value="@type")
    protected String type = "atomic";
    protected String operator;
    @XNode(value="@operatorField")
    protected String operatorField;
    @XNode(value="@operatorSchema")
    protected String operatorSchema;
    @XNodeList(value="field", componentType=FieldDescriptor.class, type=FieldDescriptor[].class)
    protected FieldDescriptor[] values;

    @XNode(value="@operator")
    public void setOperator(String operator) {
        this.operator = operator.toUpperCase();
    }

    public String getOperator() {
        return this.operator;
    }

    public String getQueryElement(DocumentModel model) throws ClientException {
        return this.getQueryElement(model, null);
    }

    public String getQueryElement(DocumentModel model, Escaper escaper) throws ClientException {
        if (ATOMIC_PREDICATE.equals(this.type)) {
            return this.atomicQueryElement(model, escaper);
        }
        if (SUB_CLAUSE_PREDICATE.equals(this.type)) {
            return this.subClauseQueryElement(model);
        }
        throw new ClientException("Unknown predicate type: " + this.type);
    }

    protected String subClauseQueryElement(DocumentModel model) throws ClientException {
        if (this.values == null || this.values.length != 1) {
            throw new ClientException("subClause predicate needs exactly one field");
        }
        FieldDescriptor fieldDescriptor = this.values[0];
        if (!fieldDescriptor.getFieldType(model).equals("string")) {
            if (fieldDescriptor.getXpath() != null) {
                throw new ClientException(String.format("type of field %s is not string", fieldDescriptor.getXpath()));
            }
            throw new ClientException(String.format("type of field %s.%s is not string", fieldDescriptor.getSchema(), fieldDescriptor.getName()));
        }
        return "(" + fieldDescriptor.getRawValue(model) + ")";
    }

    protected String atomicQueryElement(DocumentModel model, Escaper escaper) throws ClientException {
        String value;
        FieldDescriptor operatorFieldDescriptor;
        String operator = null;
        if (this.operatorField != null && this.operatorSchema != null && (operator = (operatorFieldDescriptor = new FieldDescriptor(this.operatorSchema, this.operatorField)).getPlainStringValue(model)) != null) {
            operator = operator.toUpperCase();
        }
        if (operator == null || "".equals(operator)) {
            operator = this.operator;
        }
        if (operator.equals("=") || operator.equals("!=") || operator.equals("<") || operator.equals(">") || operator.equals("<=") || operator.equals(">=") || operator.equals("<>") || operator.equals("LIKE") || operator.equals("ILIKE")) {
            value = this.values[0].getStringValue(model);
            if (value == null) {
                return "";
            }
            if (operator.equals("LIKE") || operator.equals("ILIKE")) {
                value = escaper.escape(value);
            }
            return this.serializeUnary(operator, value);
        }
        if (operator.equals("BETWEEN")) {
            String min = this.values[0].getStringValue(model);
            String max = this.values[1].getStringValue(model);
            if (min != null && max != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.parameter);
                builder.append(' ');
                builder.append(operator);
                builder.append(' ');
                builder.append(min);
                builder.append(" AND ");
                builder.append(max);
                return builder.toString();
            }
            if (max != null) {
                return this.serializeUnary("<=", max);
            }
            if (min != null) {
                return this.serializeUnary(">=", min);
            }
            return "";
        }
        if (operator.equals("IN")) {
            List<String> options = this.values[0].getListValue(model);
            if (options == null || options.isEmpty()) {
                return "";
            }
            if (options.size() == 1) {
                return this.serializeUnary("=", options.get(0));
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            for (int i = 0; i < options.size() - 1; ++i) {
                builder.append(this.serializeUnary("=", options.get(i)));
                builder.append(" OR ");
            }
            builder.append(this.serializeUnary("=", options.get(options.size() - 1)));
            builder.append(')');
            return builder.toString();
        }
        if (operator.equals("STARTSWITH")) {
            String fieldType = this.values[0].getFieldType(model);
            if (fieldType.equals("string")) {
                String value2 = this.values[0].getStringValue(model);
                if (value2 == null) {
                    return "";
                }
                return this.serializeUnary(operator, value2);
            }
            List<String> options = this.values[0].getListValue(model);
            if (options == null || options.isEmpty()) {
                return "";
            }
            if (options.size() == 1) {
                return this.serializeUnary(operator, options.get(0));
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            for (int i = 0; i < options.size() - 1; ++i) {
                builder.append(this.serializeUnary(operator, options.get(i)));
                builder.append(" OR ");
            }
            builder.append(this.serializeUnary(operator, options.get(options.size() - 1)));
            builder.append(')');
            return builder.toString();
        }
        if (operator.equals("EMPTY") || operator.equals("ISEMPTY")) {
            return this.parameter + " = ''";
        }
        if (operator.equals("FULLTEXT ALL") || operator.equals("FULLTEXT")) {
            value = this.values[0].getPlainStringValue(model);
            if (value == null) {
                return "";
            }
            String lhs = this.parameter.startsWith("ecm:fulltext") ? this.parameter : "ecm:fulltext." + this.parameter;
            return lhs + ' ' + this.serializeFullText(escaper.escape(value));
        }
        throw new ClientException("Unsupported operator: " + operator);
    }

    protected String serializeFullText(String value) {
        String res = "";
        String[] tokens = value.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                res = res + " ";
            }
            res = res + "+" + tokens[i];
        }
        return "= " + QueryModelDescriptor.prepareStringLiteral(res);
    }

    protected String serializeUnary(String operator, String rvalue) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parameter);
        builder.append(' ');
        builder.append(operator);
        builder.append(' ');
        builder.append(rvalue);
        return builder.toString();
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public FieldDescriptor[] getValues() {
        return this.values;
    }

    public void setValues(FieldDescriptor[] values) {
        this.values = values;
    }
}

