/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.collections.SinglyLinkedList;

public class MethodBlock
extends Block {
    private IRubyObject self;
    private RubyMethod method;
    private Callback callback;
    private final Arity arity;
    protected final Frame frame;
    private final SinglyLinkedList cref;
    private Visibility visibility;
    private final RubyModule klass;
    private final DynamicScope dynamicScope;
    private RubyProc proc = null;
    public boolean isLambda = false;

    public static MethodBlock createMethodBlock(ThreadContext context, DynamicScope dynamicScope, Callback callback, RubyMethod method, IRubyObject self) {
        return new MethodBlock(self, context.getCurrentFrame(), context.peekCRef(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope, callback, method);
    }

    public MethodBlock(IRubyObject self, Frame frame, SinglyLinkedList cref, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Callback callback, RubyMethod method) {
        this.self = self;
        this.frame = frame;
        this.visibility = visibility;
        this.klass = klass;
        this.cref = cref;
        this.dynamicScope = dynamicScope;
        this.callback = callback;
        this.method = method;
        this.arity = Arity.createArity((int)method.arity().getLongValue());
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true);
    }

    protected void pre(ThreadContext context, RubyModule klass) {
        context.preYieldSpecificBlock(this, klass);
    }

    protected void post(ThreadContext context) {
        context.postYield();
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.yield(context, value, null, null, false);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        this.pre(context, klass);
        while (true) {
            try {
                IRubyObject iRubyObject = this.callback.execute(value, new IRubyObject[]{this.method, self}, NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException je) {
                try {
                    if (je.getJumpType() == JumpException.JumpType.RedoJump) {
                        context.pollThreadEvents();
                        continue;
                    }
                    if (je.getJumpType() == JumpException.JumpType.BreakJump && je.getTarget() == null) {
                        je.setTarget(this);
                    }
                    throw je;
                }
                catch (JumpException je2) {
                    if (je2.getJumpType() == JumpException.JumpType.NextJump) {
                        IRubyObject iRubyObject = (IRubyObject)je2.getValue();
                        return iRubyObject;
                    }
                    throw je2;
                }
            }
            break;
        }
        finally {
            this.post(context);
        }
    }

    public Block cloneBlock() {
        MethodBlock newBlock = new MethodBlock(this.self, this.frame.duplicate(), this.cref, this.visibility, this.klass, this.dynamicScope.cloneScope(), this.callback, this.method);
        newBlock.type = this.type;
        return newBlock;
    }

    public Arity arity() {
        return this.arity;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public SinglyLinkedList getCRef() {
        return this.cref;
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public boolean isGiven() {
        return true;
    }
}

