/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.StarNode;
import org.jruby.evaluator.EvaluationState;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AssignmentVisitor {
    public static IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block, boolean check) {
        IRubyObject result = null;
        switch (node.nodeId) {
            case 102: {
                AssignmentVisitor.attrAssignNode(runtime, context, self, node, value, block);
                break;
            }
            case 15: {
                AssignmentVisitor.callNode(runtime, context, self, node, value, block);
                break;
            }
            case 18: {
                AssignmentVisitor.classVarAsgnNode(context, node, value);
                break;
            }
            case 19: {
                AssignmentVisitor.classVarDeclNode(runtime, context, node, value);
                break;
            }
            case 23: {
                AssignmentVisitor.constDeclNode(runtime, context, self, node, value, block);
                break;
            }
            case 25: {
                AssignmentVisitor.dasgnNode(context, node, value);
                break;
            }
            case 43: {
                AssignmentVisitor.globalAsgnNode(runtime, node, value);
                break;
            }
            case 47: {
                AssignmentVisitor.instAsgnNode(self, node, value);
                break;
            }
            case 52: {
                AssignmentVisitor.localAsgnNode(context, node, value);
                break;
            }
            case 58: {
                result = AssignmentVisitor.multipleAsgnNode(runtime, context, self, node, value, check);
                break;
            }
            default: {
                throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
            }
        }
        return result;
    }

    private static void attrAssignNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block) {
        CallType callType;
        AttrAssignNode iVisited = (AttrAssignNode)node;
        IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, block);
        CallType callType2 = callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
        if (iVisited.getArgsNode() == null) {
            receiver.callMethod(context, iVisited.getName(), new IRubyObject[]{value}, callType);
        } else {
            RubyArray args = (RubyArray)EvaluationState.eval(runtime, context, iVisited.getArgsNode(), self, block);
            args.append(value);
            receiver.callMethod(context, iVisited.getName(), args.toJavaArray(), callType);
        }
    }

    private static void callNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block) {
        CallNode iVisited = (CallNode)node;
        IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, block);
        if (iVisited.getArgsNode() == null) {
            receiver.callMethod(context, iVisited.getName(), new IRubyObject[]{value}, CallType.NORMAL);
        } else {
            RubyArray args = (RubyArray)EvaluationState.eval(runtime, context, iVisited.getArgsNode(), self, block);
            args.append(value);
            receiver.callMethod(context, iVisited.getName(), args.toJavaArray(), CallType.NORMAL);
        }
    }

    private static void classVarAsgnNode(ThreadContext context, Node node, IRubyObject value) {
        ClassVarAsgnNode iVisited = (ClassVarAsgnNode)node;
        context.getRubyClass().setClassVar(iVisited.getName(), value);
    }

    private static void classVarDeclNode(Ruby runtime, ThreadContext context, Node node, IRubyObject value) {
        ClassVarDeclNode iVisited = (ClassVarDeclNode)node;
        if (runtime.getVerbose().isTrue() && context.getRubyClass().isSingleton()) {
            runtime.getWarnings().warn(iVisited.getPosition(), "Declaring singleton class variable.");
        }
        context.getRubyClass().setClassVar(iVisited.getName(), value);
    }

    private static void constDeclNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block) {
        IRubyObject module;
        ConstDeclNode iVisited = (ConstDeclNode)node;
        Node constNode = iVisited.getConstNode();
        if (constNode == null) {
            if (context.getRubyClass() == null) {
                throw runtime.newTypeError("no class/module to define constant");
            }
            module = (RubyModule)context.peekCRef().getValue();
        } else {
            module = constNode instanceof Colon2Node ? EvaluationState.eval(runtime, context, ((Colon2Node)iVisited.getConstNode()).getLeftNode(), self, block) : runtime.getObject();
        }
        ((RubyModule)module).setConstant(iVisited.getName(), value);
    }

    private static void dasgnNode(ThreadContext context, Node node, IRubyObject value) {
        DAsgnNode iVisited = (DAsgnNode)node;
        context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
    }

    private static void globalAsgnNode(Ruby runtime, Node node, IRubyObject value) {
        GlobalAsgnNode iVisited = (GlobalAsgnNode)node;
        runtime.getGlobalVariables().set(iVisited.getName(), value);
    }

    private static void instAsgnNode(IRubyObject self, Node node, IRubyObject value) {
        InstAsgnNode iVisited = (InstAsgnNode)node;
        self.setInstanceVariable(iVisited.getName(), value);
    }

    private static void localAsgnNode(ThreadContext context, Node node, IRubyObject value) {
        LocalAsgnNode iVisited = (LocalAsgnNode)node;
        context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
    }

    public static IRubyObject multiAssign(Ruby runtime, ThreadContext context, IRubyObject self, MultipleAsgnNode node, RubyArray value, boolean callAsProc) {
        int j;
        int valueLen = value.getLength();
        int varLen = node.getHeadNode() == null ? 0 : node.getHeadNode().size();
        for (j = 0; j < valueLen && j < varLen; ++j) {
            Node lNode = node.getHeadNode().get(j);
            AssignmentVisitor.assign(runtime, context, self, lNode, value.eltInternal(j), Block.NULL_BLOCK, callAsProc);
        }
        if (callAsProc && j < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        Node argsNode = node.getArgsNode();
        if (argsNode != null) {
            if (!(argsNode instanceof StarNode)) {
                if (varLen < valueLen) {
                    AssignmentVisitor.assign(runtime, context, self, argsNode, value.subseqLight(varLen, valueLen), Block.NULL_BLOCK, callAsProc);
                } else {
                    AssignmentVisitor.assign(runtime, context, self, argsNode, RubyArray.newArrayLight(runtime, 0L), Block.NULL_BLOCK, callAsProc);
                }
            }
        } else if (callAsProc && valueLen < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        while (j < varLen) {
            AssignmentVisitor.assign(runtime, context, self, node.getHeadNode().get(j++), runtime.getNil(), Block.NULL_BLOCK, callAsProc);
        }
        return value;
    }

    private static IRubyObject multipleAsgnNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, boolean check) {
        MultipleAsgnNode iVisited = (MultipleAsgnNode)node;
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArrayNoCopyLight(runtime, new IRubyObject[]{value});
        }
        IRubyObject result = AssignmentVisitor.multiAssign(runtime, context, self, iVisited, (RubyArray)value, check);
        return result;
    }
}

