/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyDigest {
    private static Provider provider = null;

    public static void createDigest(Ruby runtime) {
        try {
            Class<?> c = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            provider = (Provider)c.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        RubyModule mDigest = runtime.defineModule("Digest");
        RubyClass cDigestBase = mDigest.defineClassUnder("Base", runtime.getObject(), Base.BASE_ALLOCATOR);
        CallbackFactory basecb = runtime.callbackFactory(Base.class);
        cDigestBase.getMetaClass().defineFastMethod("digest", basecb.getFastSingletonMethod("s_digest", RubyKernel.IRUBY_OBJECT));
        cDigestBase.getMetaClass().defineFastMethod("hexdigest", basecb.getFastSingletonMethod("s_hexdigest", RubyKernel.IRUBY_OBJECT));
        cDigestBase.defineMethod("initialize", basecb.getOptMethod("initialize"));
        cDigestBase.defineFastMethod("initialize_copy", basecb.getFastMethod("initialize_copy", RubyKernel.IRUBY_OBJECT));
        cDigestBase.defineFastMethod("update", basecb.getFastMethod("update", RubyKernel.IRUBY_OBJECT));
        cDigestBase.defineFastMethod("<<", basecb.getFastMethod("update", RubyKernel.IRUBY_OBJECT));
        cDigestBase.defineFastMethod("digest", basecb.getFastMethod("digest"));
        cDigestBase.defineFastMethod("hexdigest", basecb.getFastMethod("hexdigest"));
        cDigestBase.defineFastMethod("to_s", basecb.getFastMethod("hexdigest"));
        cDigestBase.defineFastMethod("==", basecb.getFastMethod("eq", RubyKernel.IRUBY_OBJECT));
    }

    private static MessageDigest createMessageDigest(Ruby runtime, String providerName) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return MessageDigest.getInstance(providerName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(providerName);
    }

    public static void createDigestMD5(Ruby runtime) {
        runtime.getLoadService().require("digest.so");
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_MD5 = mDigest.defineClassUnder("MD5", cDigestBase, cDigestBase.getAllocator());
        cDigest_MD5.setClassVar("metadata", runtime.newString("MD5"));
    }

    public static void createDigestRMD160(Ruby runtime) {
        runtime.getLoadService().require("digest.so");
        if (provider == null) {
            throw runtime.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_RMD160 = mDigest.defineClassUnder("RMD160", cDigestBase, cDigestBase.getAllocator());
        cDigest_RMD160.setClassVar("metadata", runtime.newString("RIPEMD160"));
    }

    public static void createDigestSHA1(Ruby runtime) {
        runtime.getLoadService().require("digest.so");
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_SHA1 = mDigest.defineClassUnder("SHA1", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA1.setClassVar("metadata", runtime.newString("SHA1"));
    }

    public static void createDigestSHA2(Ruby runtime) {
        runtime.getLoadService().require("digest.so");
        try {
            RubyDigest.createMessageDigest(runtime, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newLoadError("SHA2 not supported");
        }
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_SHA2_256 = mDigest.defineClassUnder("SHA256", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_256.setClassVar("metadata", runtime.newString("SHA-256"));
        RubyClass cDigest_SHA2_384 = mDigest.defineClassUnder("SHA384", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_384.setClassVar("metadata", runtime.newString("SHA-384"));
        RubyClass cDigest_SHA2_512 = mDigest.defineClassUnder("SHA512", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_512.setClassVar("metadata", runtime.newString("SHA-512"));
    }

    public static class Base
    extends RubyObject {
        protected static ObjectAllocator BASE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Base(runtime, klass);
            }
        };
        private MessageDigest algo;
        private StringBuffer data = new StringBuffer();

        public static IRubyObject s_digest(IRubyObject recv, IRubyObject str) {
            Ruby runtime = recv.getRuntime();
            String name = ((RubyClass)recv).getClassVar("metadata").toString();
            try {
                MessageDigest md = RubyDigest.createMessageDigest(runtime, name);
                return RubyString.newString(runtime, md.digest(str.convertToString().getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
        }

        public static IRubyObject s_hexdigest(IRubyObject recv, IRubyObject str) {
            Ruby runtime = recv.getRuntime();
            String name = ((RubyClass)recv).getClassVar("metadata").toString();
            try {
                MessageDigest md = RubyDigest.createMessageDigest(runtime, name);
                return RubyString.newString(runtime, ByteList.plain(Base.toHex(md.digest(str.convertToString().getBytes()))));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
        }

        public Base(Ruby runtime, RubyClass type) {
            super(runtime, type);
            if (type == runtime.getModule("Digest").getClass("Base")) {
                throw runtime.newNotImplementedError("Digest::Base is an abstract class");
            }
            if (!type.isClassVarDefined("metadata")) {
                throw runtime.newNotImplementedError("the " + type + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(type.getClassVar("metadata"));
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime.newNotImplementedError("the " + type + "() function is unimplemented on this machine");
            }
        }

        public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
            if (args.length > 0 && !args[0].isNil()) {
                this.update(args[0]);
            }
            return this;
        }

        public IRubyObject initialize_copy(IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            ((RubyObject)obj).checkFrozen();
            this.data = new StringBuffer(((Base)obj).data.toString());
            String name = ((Base)obj).algo.getAlgorithm();
            try {
                this.algo = RubyDigest.createMessageDigest(this.getRuntime(), name);
            }
            catch (NoSuchAlgorithmException e) {
                throw this.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
            return this;
        }

        public IRubyObject update(IRubyObject obj) {
            this.data.append(obj);
            return this;
        }

        public IRubyObject digest() {
            this.algo.reset();
            return RubyString.newString(this.getRuntime(), this.algo.digest(ByteList.plain(this.data)));
        }

        public IRubyObject hexdigest() {
            this.algo.reset();
            return RubyString.newString(this.getRuntime(), ByteList.plain(Base.toHex(this.algo.digest(ByteList.plain(this.data)))));
        }

        public IRubyObject eq(IRubyObject oth) {
            boolean ret;
            boolean bl = ret = this == oth;
            if (!ret && oth instanceof Base) {
                Base b = (Base)oth;
                ret = this.algo.getAlgorithm().equals(b.algo.getAlgorithm()) && this.digest().equals(b.digest());
            }
            return ret ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        private void setAlgorithm(IRubyObject algo) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(this.getRuntime(), algo.toString());
        }

        private static String toHex(byte[] val) {
            StringBuffer out = new StringBuffer();
            int j = val.length;
            for (int i = 0; i < j; ++i) {
                String ve = Integer.toString((char)val[i] & 0xFF, 16);
                if (ve.length() == 1) {
                    ve = "0" + ve;
                }
                out.append(ve);
            }
            return out.toString();
        }
    }
}

