/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Servlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;

public class NetServer {
    protected static NetServer instance;
    protected final Server server;
    protected Map<Connector, AtomicLong> connectorRefs = new HashMap<Connector, AtomicLong>();
    protected Map<Context, AtomicLong> contextRefs = new HashMap<Context, AtomicLong>();

    public static String add(RepositoryDescriptor.ServerDescriptor serverDescriptor, String servletName, Servlet servlet, String path) {
        return NetServer.instance().addRepositoryServer(serverDescriptor, servletName, servlet, path);
    }

    public static void remove(RepositoryDescriptor.ServerDescriptor serverDescriptor, String servletName) {
        NetServer.instance().removeRepositoryServer(serverDescriptor, servletName);
    }

    protected static synchronized NetServer instance() {
        if (instance == null) {
            instance = new NetServer();
            try {
                NetServer.instance.server.start();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    protected static synchronized void shutDown() {
        if (instance != null) {
            Server server = NetServer.instance.server;
            instance = null;
            try {
                server.stop();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected NetServer() {
        this.server = new Server();
        this.server.setHandlers((Handler[])new ContextHandler[0]);
    }

    protected String addRepositoryServer(RepositoryDescriptor.ServerDescriptor serverDescriptor, String servletName, Servlet servlet, String path) {
        try {
            this.addConnector(serverDescriptor);
            String contextPath = this.getContextPath(serverDescriptor);
            Context context = this.addContext(contextPath);
            ServletHandler servletHandler = context.getServletHandler();
            ServletHolder servletHolder = new ServletHolder(servlet);
            servletHolder.setName(servletName);
            if (!path.startsWith("/")) {
                path = '/' + path;
            }
            servletHandler.addServletWithMapping(servletHolder, path);
            return "http://" + serverDescriptor.host + ':' + serverDescriptor.port + contextPath + path;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void removeRepositoryServer(RepositoryDescriptor.ServerDescriptor serverDescriptor, String servletName) {
        try {
            boolean stop = this.removeConnector(serverDescriptor);
            Context context = this.removeContext(this.getContextPath(serverDescriptor));
            ServletHandler servletHandler = context.getServletHandler();
            LinkedList<ServletHolder> sl = new LinkedList<ServletHolder>(Arrays.asList(servletHandler.getServlets()));
            Iterator it = sl.iterator();
            while (it.hasNext()) {
                ServletHolder s = (ServletHolder)it.next();
                if (!s.getName().equals(servletName)) continue;
                it.remove();
                break;
            }
            servletHandler.setServlets(sl.toArray(new ServletHolder[0]));
            if (stop) {
                NetServer.shutDown();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getContextPath(RepositoryDescriptor.ServerDescriptor serverDescriptor) {
        String contextPath = serverDescriptor.path;
        if (!contextPath.startsWith("/")) {
            contextPath = '/' + contextPath;
        }
        return contextPath;
    }

    protected void addConnector(RepositoryDescriptor.ServerDescriptor serverDescriptor) throws Exception {
        Connector connector = this.getConnector(serverDescriptor);
        if (connector == null) {
            connector = new SocketConnector();
            connector.setHost(serverDescriptor.host);
            connector.setPort(serverDescriptor.port);
            this.server.addConnector(connector);
            connector.start();
            this.connectorRefs.put(connector, new AtomicLong());
        }
        this.connectorRefs.get(connector).incrementAndGet();
    }

    protected boolean removeConnector(RepositoryDescriptor.ServerDescriptor serverDescriptor) throws Exception {
        Connector connector = this.getConnector(serverDescriptor);
        if (connector == null) {
            throw new RuntimeException("Unknown connector for: " + serverDescriptor);
        }
        long refs = this.connectorRefs.get(connector).decrementAndGet();
        if (refs == 0L) {
            this.connectorRefs.remove(connector);
            connector.stop();
            LinkedList<Connector> cl = new LinkedList<Connector>(Arrays.asList(this.server.getConnectors()));
            cl.remove(connector);
            this.server.setConnectors(cl.toArray(new Connector[0]));
            if (cl.size() == 0) {
                return true;
            }
        }
        return false;
    }

    protected Connector getConnector(RepositoryDescriptor.ServerDescriptor serverDescriptor) {
        Connector[] connectors = this.server.getConnectors();
        if (connectors == null) {
            return null;
        }
        for (Connector c : connectors) {
            if (!c.getHost().equals(serverDescriptor.host) || c.getPort() != serverDescriptor.port) continue;
            return c;
        }
        return null;
    }

    protected Context addContext(String path) throws Exception {
        Context context = this.getContext(path);
        if (context == null) {
            context = new Context((HandlerContainer)this.server, path, 1);
            context.start();
            this.contextRefs.put(context, new AtomicLong());
        }
        this.contextRefs.get(context).incrementAndGet();
        return context;
    }

    protected Context removeContext(String path) throws Exception {
        Context context = this.getContext(path);
        if (context == null) {
            throw new RuntimeException("Unknown context: " + path);
        }
        long refs = this.contextRefs.get(context).decrementAndGet();
        if (refs == 0L) {
            this.contextRefs.remove(context);
            context.stop();
            this.server.removeHandler((Handler)context);
        }
        return context;
    }

    protected Context getContext(String path) {
        Handler[] handlers = this.server.getHandlers();
        if (handlers == null) {
            return null;
        }
        for (Handler h : handlers) {
            Context c;
            if (!(h instanceof Context) || !(c = (Context)h).getContextPath().equals(path)) continue;
            return c;
        }
        return null;
    }
}

