/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.model.NoSuchRepositoryException;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepository;
import org.nuxeo.ecm.core.storage.sql.net.MapperClient;
import org.nuxeo.ecm.core.storage.sql.net.MapperInvoker;
import org.nuxeo.ecm.core.storage.sql.net.OutputStreamToWriter;

public class MapperServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(MapperServlet.class);
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private Repository repository;
    private boolean initialized;
    private Map<String, MapperInvoker> invokers;
    private final AtomicInteger threadNumber = new AtomicInteger();

    public MapperServlet(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public static String getName(String repositoryName) {
        return MapperServlet.class.getSimpleName() + '-' + repositoryName;
    }

    protected synchronized void initialize() {
        org.nuxeo.ecm.core.model.Repository repo;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            try {
                repo = NXCore.getRepository((String)this.repositoryName);
            }
            catch (NoSuchRepositoryException e) {
                repo = NXCore.getRepositoryService().getRepositoryManager().getRepository(this.repositoryName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (repo instanceof Repository) {
            this.repository = (Repository)repo;
        } else if (repo instanceof SQLRepository) {
            this.repository = ((SQLRepository)repo).repository;
        } else {
            throw new RuntimeException("Unknown repository class: " + repo.getClass().getName());
        }
        this.invokers = Collections.synchronizedMap(new HashMap());
    }

    public void destroy() {
        if (this.invokers != null) {
            for (Map.Entry<String, MapperInvoker> es : this.invokers.entrySet()) {
                MapperInvoker invoker = es.getValue();
                try {
                    invoker.call("close", new Object[0]);
                    invoker.close();
                }
                catch (Throwable e) {
                    log.error((Object)("Cannot close invoker " + es.getKey()));
                }
            }
        }
        super.destroy();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initialize();
        String sid = req.getParameter("sid");
        if ("".equals(sid)) {
            sid = null;
        }
        ServletInputStream is = req.getInputStream();
        try {
            Object object;
            MapperInvoker invoker;
            if (sid == null) {
                String name = "Nuxeo-VCS-NetServlet-" + this.threadNumber.incrementAndGet();
                invoker = new MapperInvoker(this.repository, name);
                sid = (String)invoker.call("getMapperId", new Object[0]);
                this.invokers.put(sid, invoker);
            } else {
                invoker = this.invokers.get(sid);
                if (invoker == null) {
                    throw new RuntimeException("Unknown session id (maybe timed out): " + sid);
                }
            }
            resp.setContentType("application/octet-stream");
            PrintWriter writer = resp.getWriter();
            ObjectOutputStream oos = new ObjectOutputStream(new OutputStreamToWriter(writer));
            ObjectInputStream ois = new ObjectInputStream((InputStream)is);
            String methodName = (String)ois.readObject();
            LinkedList<Object> args = new LinkedList<Object>();
            while ((object = ois.readObject()) != MapperClient.EOF) {
                args.add(object);
            }
            Object res = invoker.call(methodName, args.toArray());
            if ("close".equals(methodName)) {
                invoker.close();
                this.invokers.remove(sid);
            }
            oos.writeObject(res);
            oos.flush();
            oos.close();
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            resp.sendError(500, e.toString());
        }
    }
}

