/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.net.ObjectWriterRequestEntity;

public class MapperClient
implements InvocationHandler {
    public static final Object EOF = Eof.VALUE;
    protected String mapperId;
    protected final String url;
    protected final HttpClient httpClient;

    public static Mapper getMapper(RepositoryImpl repository) throws StorageException {
        MapperClient handler = new MapperClient(repository);
        Mapper mapper = (Mapper)Proxy.newProxyInstance(MapperClient.class.getClassLoader(), new Class[]{Mapper.class}, (InvocationHandler)handler);
        handler.mapperId = mapper.getMapperId();
        return mapper;
    }

    protected MapperClient(RepositoryImpl repository) {
        this.httpClient = repository.getHttpClient();
        this.url = MapperClient.getUrl(repository.getRepositoryDescriptor());
    }

    protected static String getUrl(RepositoryDescriptor repositoryDescriptor) {
        RepositoryDescriptor.ServerDescriptor sd = repositoryDescriptor.connect.get(0);
        return sd.getUrl() + '/' + "vcs";
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getMapperId".equals(methodName)) {
            if (this.mapperId != null) {
                return this.mapperId;
            }
        } else {
            if ("getTableSize".equals(methodName)) {
                return this.getTableSize((String)args[0]);
            }
            if ("createDatabase".equals(methodName)) {
                this.createDatabase();
                return null;
            }
        }
        String postUrl = this.url;
        if (this.mapperId != null) {
            postUrl = postUrl + "?sid=" + this.mapperId;
        }
        PostMethod m = new PostMethod(postUrl);
        try {
            ObjectWriterRequestEntity writer = new ObjectWriterRequestEntity();
            writer.add(methodName, args);
            m.setRequestEntity((RequestEntity)writer);
            int status = this.httpClient.executeMethod((HttpMethod)m);
            if (status != 200) {
                throw new ProtocolException(String.valueOf(status));
            }
            String cs = m.getResponseCharSet();
            if (cs != null && !cs.equals("ISO-8859-1")) {
                throw new RuntimeException("Bad encoding: " + cs);
            }
            Object res = new ObjectInputStream(m.getResponseBodyAsStream()).readObject();
            if (res instanceof Throwable) {
                Throwable t = (Throwable)res;
                throw new StorageException("Remote exception: " + t, t);
            }
            Object object = res;
            return object;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    public int getTableSize(String tableName) {
        return 5;
    }

    public void createDatabase() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Eof {
        VALUE;

    }
}

