/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStatement {
    public static final String DIALECT_WITH_NO_SEMICOLON = "noSemicolon";
    public static final String CATEGORY = "#CATEGORY:";
    public final String sql;
    public final List<Tag> tags;

    public SQLStatement(String sql, List<Tag> tags) {
        this.sql = sql;
        this.tags = tags == null ? Collections.emptyList() : tags;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SQLStatement(");
        for (Tag tag : this.tags) {
            buf.append(tag.key);
            String value = tag.value;
            if (value != null) {
                buf.append(' ');
                buf.append(value);
            }
            buf.append(", ");
        }
        buf.append(this.sql);
        buf.append(')');
        return buf.toString();
    }

    public static Map<String, List<SQLStatement>> read(String filename, Map<String, List<SQLStatement>> statements) throws IOException {
        String line;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Cannot open: " + filename);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String category = null;
        LinkedList<Tag> tags = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(CATEGORY)) {
                category = line.substring(CATEGORY.length()).trim();
                continue;
            }
            if (line.startsWith("#TEST:") || line.startsWith("#IF:")) {
                String key = line.substring(0, line.indexOf(58) + 1);
                String value = line.substring(key.length()).trim();
                if (value.length() == 0) {
                    value = null;
                }
                if (tags == null) {
                    tags = new LinkedList<Tag>();
                }
                tags.add(new Tag(key, value));
                continue;
            }
            if (line.startsWith("#")) continue;
            StringBuilder buf = new StringBuilder();
            boolean read = false;
            while (true) {
                if (read) {
                    line = reader.readLine();
                } else {
                    read = true;
                }
                if (line == null || line.trim().equals("")) {
                    if (buf.length() == 0) break;
                    String sql = buf.toString().trim();
                    SQLStatement statement = new SQLStatement(sql, tags);
                    List<SQLStatement> catStatements = statements.get(category);
                    if (catStatements == null) {
                        catStatements = new LinkedList<SQLStatement>();
                        statements.put(category, catStatements);
                    }
                    catStatements.add(statement);
                    break;
                }
                if (line.startsWith("#")) continue;
                buf.append(line);
                buf.append('\n');
            }
            tags = null;
            if (line != null) continue;
            break;
        }
        return statements;
    }

    protected static String replaceVars(String sql, Map<String, Serializable> properties) {
        if (properties != null) {
            for (Map.Entry<String, Serializable> en : properties.entrySet()) {
                String key = "${" + en.getKey() + "}";
                String value = String.valueOf(en.getValue());
                sql = sql.replaceAll(Pattern.quote(key), Matcher.quoteReplacement(value));
            }
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(List<SQLStatement> statements, Map<String, Serializable> properties, JDBCConnection jdbc) throws SQLException {
        Statement st = jdbc.connection.createStatement();
        try {
            block3: for (SQLStatement statement : statements) {
                String msg;
                boolean test = false;
                for (Tag tag : statement.tags) {
                    Serializable value;
                    if (tag.key.equals("#TEST:")) {
                        test = true;
                        continue;
                    }
                    if (!tag.key.equals("#IF:")) continue;
                    String key = tag.value;
                    boolean neg = key.startsWith("!");
                    if (neg) {
                        key = key.substring(1).trim();
                    }
                    if ((value = properties.get(key)) == null) {
                        jdbc.logger.error("Unknown condition: " + key);
                        continue block3;
                    }
                    if (!(value instanceof Boolean)) {
                        jdbc.logger.error("Not a boolean condition: " + key);
                        continue block3;
                    }
                    if ((Boolean)value != neg) continue;
                    continue block3;
                }
                String sql = statement.sql;
                if ((sql = SQLStatement.replaceVars(sql, properties)).startsWith("LOG.DEBUG")) {
                    msg = sql.substring("LOG.DEBUG".length()).trim();
                    jdbc.logger.log(msg);
                    continue;
                }
                if (sql.startsWith("LOG.INFO")) {
                    msg = sql.substring("LOG.INFO".length()).trim();
                    jdbc.logger.info(msg);
                    continue;
                }
                if (sql.startsWith("LOG.ERROR")) {
                    msg = sql.substring("LOG.ERROR".length()).trim();
                    jdbc.logger.error(msg);
                    continue;
                }
                if (sql.startsWith("LOG.FATAL")) {
                    msg = sql.substring("LOG.FATAL".length()).trim();
                    jdbc.logger.error(msg);
                    throw new SQLException("Fatal error: " + msg);
                }
                jdbc.logger.log(sql.replace("\n", "\n    "));
                if (sql.endsWith(";") && properties.containsKey(DIALECT_WITH_NO_SEMICOLON)) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (test) {
                    ResultSet rs = st.executeQuery(sql);
                    Boolean emptyResult = !rs.next();
                    properties.put("emptyResult", emptyResult);
                    jdbc.logger.log("  -> emptyResult = " + emptyResult);
                    continue;
                }
                st.execute(sql);
            }
        }
        finally {
            st.close();
        }
    }

    public static class Tag {
        public static final String TAG_TEST = "#TEST:";
        public static final String TAG_IF = "#IF:";
        public static final String VAR_EMPTY_RESULT = "emptyResult";
        public String key;
        public String value;

        public Tag(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

