/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectDerby
extends Dialect {
    private final String derbyFunctions = "org.nuxeo.ecm.core.storage.sql.db.DerbyFunctions";

    public DialectDerby(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("VARCHAR(32672)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("SMALLINT", 5);
            }
            case LONG: {
                return this.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("SMALLINT", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case FTINDEXED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR(4000)", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case 5: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return this.getBinaryManager().getBinary(string);
                }
                return string;
            }
            case 5: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 0;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        return query;
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String colFmt;
        Column ftColumn = database.getTable("fulltext").getColumn("fulltext");
        String qname = ftColumn.getFullQuotedName();
        if (ftColumn.getJdbcType() == 2005 && (colFmt = this.getClobCast(false)) != null) {
            qname = String.format(colFmt, qname, 255);
        }
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.whereExpr = String.format("NX_CONTAINS(%s, ?) = 1", qname);
        info.whereExprParam = fulltextQuery;
        return info;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return false;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS VARCHAR(%d))";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/derby.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/derby.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR(36)"));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("derbyFunctions", (Serializable)((Object)"org.nuxeo.ecm.core.storage.sql.db.DerbyFunctions"));
        properties.put("noSemicolon", Boolean.TRUE);
        return properties;
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String getPagingClause(long limit, long offset) {
        return String.format("OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", offset, limit);
    }
}

