/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Join
implements Serializable,
Comparable<Join> {
    private static final long serialVersionUID = 1L;
    public static final int INNER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int IMPLICIT = 4;
    public int kind;
    public String table;
    public String tableAlias;
    public String tableParam;
    public String on1;
    public String on2;

    public Join(int kind, String table, String tableAlias, String tableParam, String on1, String on2) {
        this.kind = kind;
        this.table = table;
        this.tableAlias = tableAlias;
        this.tableParam = tableParam;
        this.on1 = on1;
        this.on2 = on2;
    }

    @Override
    public int compareTo(Join other) {
        if (this.kind == 4 && other.kind == 4) {
            return 0;
        }
        if (this.kind == 4) {
            return 1;
        }
        if (other.kind == 4) {
            return -1;
        }
        return 0;
    }

    public String getTable() {
        if (this.tableAlias == null) {
            return this.table;
        }
        return this.table + " " + this.tableAlias;
    }

    public String getClause() {
        return String.format("%s = %s", this.on1, this.on2);
    }

    public String toString() {
        switch (this.kind) {
            case 1: {
                return String.format(" JOIN %s ON %s", this.getTable(), this.getClause());
            }
            case 2: {
                return String.format(" LEFT JOIN %s ON %s", this.getTable(), this.getClause());
            }
            case 3: {
                return String.format(" RIGHT JOIN %s ON %s", this.getTable(), this.getClause());
            }
            case 4: {
                return String.format(", %s", this.getTable());
            }
        }
        throw new AssertionError();
    }
}

