/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BinaryManager binaryManager;
    protected final Dialect dialect;
    protected final Map<String, Table> tables;
    protected final Set<String> physicalTables;

    public Database(RepositoryImpl repository, Dialect dialect) {
        this.binaryManager = repository.getBinaryManager();
        this.dialect = dialect;
        this.tables = new LinkedHashMap<String, Table>();
        this.physicalTables = new HashSet<String>();
    }

    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public Table addTable(String name) throws IllegalArgumentException {
        String physicalName = this.getTablePhysicalName(name);
        if (!this.physicalTables.add(physicalName)) {
            throw new IllegalArgumentException("Duplicate table name: " + physicalName);
        }
        TableImpl table = new TableImpl(this, physicalName);
        this.tables.put(name, table);
        return table;
    }

    protected String getPhysicalName(String name) {
        String physicalName = this.dialect.storesUpperCaseIdentifiers() ? name.toUpperCase() : name.toLowerCase();
        return physicalName.replace(':', '_');
    }

    protected String getTablePhysicalName(String name) {
        return this.getPhysicalName(name);
    }

    protected String getColumnPhysicalName(String name) {
        return this.getPhysicalName(name);
    }

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('(');
        Iterator<Table> iter = this.tables.values().iterator();
        while (iter.hasNext()) {
            Table table = iter.next();
            buf.append(table.getName());
            if (!iter.hasNext()) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }
}

