/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.CollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarCollectionIO
implements CollectionIO {
    public static final CollectionIO INSTANCE = new ScalarCollectionIO();

    @Override
    public Serializable getCurrentFromResultSet(ResultSet rs, List<Column> columns, Model model, Serializable[] returnId, int[] returnPos) throws SQLException {
        int pos;
        Object id = null;
        Serializable value = null;
        int i = 0;
        for (Column column : columns) {
            String key = column.getKey();
            Serializable v = column.getFromResultSet(rs, ++i);
            if (key.equals("id")) {
                id = v;
                continue;
            }
            if (key.equals("pos")) continue;
            if (key.equals("item")) {
                value = v;
                continue;
            }
            throw new RuntimeException(key);
        }
        Serializable prevId = returnId[0];
        returnId[0] = id;
        returnPos[0] = pos = id != null && !id.equals(prevId) ? 0 : returnPos[0] + 1;
        return value;
    }

    @Override
    public void setToPreparedStatement(Serializable id, Serializable[] array, List<Column> columns, PreparedStatement ps, Model model, List<Serializable> debugValues, String sql, JDBCMapperLogger logger) throws SQLException {
        for (int i = 0; i < array.length; ++i) {
            int n = 0;
            for (Column column : columns) {
                Serializable v;
                ++n;
                String key = column.getKey();
                if (key.equals("id")) {
                    v = id;
                } else if (key.equals("pos")) {
                    v = Long.valueOf(i);
                } else if (key.equals("item")) {
                    v = array[i];
                } else {
                    throw new RuntimeException(key);
                }
                column.setToPreparedStatement(ps, n, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            if (debugValues != null) {
                logger.logSQL(sql, debugValues);
                debugValues.clear();
            }
            ps.execute();
        }
    }
}

