/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;

public class JDBCConnection {
    protected final Model model;
    protected final SQLInfo sqlInfo;
    protected final XADataSource xadatasource;
    private XAConnection xaconnection;
    public Connection connection;
    protected XAResource xaresource;
    private static final AtomicLong instanceCounter = new AtomicLong(0L);
    private final long instanceNumber = instanceCounter.incrementAndGet();
    public final JDBCMapperLogger logger = new JDBCMapperLogger(this.instanceNumber);

    public JDBCConnection(Model model, SQLInfo sqlInfo, XADataSource xadatasource) throws StorageException {
        this.model = model;
        this.sqlInfo = sqlInfo;
        this.xadatasource = xadatasource;
        this.resetConnection();
    }

    public String getMapperId() {
        return "M" + this.instanceNumber;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (this.xaconnection != null) {
            try {
                this.xaconnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.xaconnection = null;
        this.connection = null;
        this.xaresource = null;
    }

    protected void resetConnection() throws StorageException {
        this.close();
        try {
            this.xaconnection = this.xadatasource.getXAConnection();
            this.connection = this.xaconnection.getConnection();
            this.xaresource = this.xaconnection.getXAResource();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected void checkConnectionReset(SQLException e) throws StorageException {
        if (this.sqlInfo.dialect.connectionClosedByException(e)) {
            this.resetConnection();
        }
    }

    protected void checkConnectionReset(XAException e) {
        if (this.sqlInfo.dialect.connectionClosedByException(e)) {
            try {
                this.resetConnection();
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement s) throws SQLException {
        try {
            s.close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

