/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.DocumentProxy;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.versioning.DocumentVersion;
import org.nuxeo.ecm.core.versioning.DocumentVersionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDocumentProxy
implements SQLDocument,
DocumentProxy {
    private final Document proxy;
    private Document target;

    protected SQLDocumentProxy(Document proxy, Document target) throws DocumentException {
        this.proxy = proxy;
        this.target = target;
    }

    @Override
    public Node getNode() {
        return ((SQLDocument)this.proxy).getNode();
    }

    @Override
    public Property getACLProperty() throws DocumentException {
        return ((SQLDocument)this.proxy).getACLProperty();
    }

    @Override
    public void checkWritable() throws DocumentException {
        ((SQLDocument)this.target).checkWritable();
    }

    public boolean isProxy() {
        return true;
    }

    public String getName() throws DocumentException {
        return this.proxy.getName();
    }

    public String getUUID() throws DocumentException {
        return this.proxy.getUUID();
    }

    public Document getParent() throws DocumentException {
        return this.proxy.getParent();
    }

    public String getPath() throws DocumentException {
        return this.proxy.getPath();
    }

    public void remove() throws DocumentException {
        this.proxy.remove();
    }

    public DocumentType getType() {
        return this.target.getType();
    }

    public Repository getRepository() {
        return this.target.getRepository();
    }

    public Session getSession() {
        return this.target.getSession();
    }

    public boolean isFolder() {
        return this.target.isFolder();
    }

    public Calendar getLastModified() throws DocumentException {
        return this.target.getLastModified();
    }

    public void save() throws DocumentException {
        this.target.save();
    }

    public boolean isDirty() throws DocumentException {
        return this.target.isDirty();
    }

    public void setDirty(boolean value) throws DocumentException {
        this.target.setDirty(value);
    }

    public void readDocumentPart(DocumentPart dp) throws Exception {
        this.target.readDocumentPart(dp);
    }

    public void writeDocumentPart(DocumentPart dp) throws Exception {
        this.target.writeDocumentPart(dp);
    }

    public <T extends Serializable> void setSystemProp(String name, T value) throws DocumentException {
        this.target.setSystemProp(name, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        return (T)this.target.getSystemProp(name, type);
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        return this.target.getLifeCyclePolicy();
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        this.target.setLifeCyclePolicy(policy);
    }

    public String getCurrentLifeCycleState() throws LifeCycleException {
        return this.target.getCurrentLifeCycleState();
    }

    public void setCurrentLifeCycleState(String state) throws LifeCycleException {
        this.target.setCurrentLifeCycleState(state);
    }

    public boolean followTransition(String transition) throws LifeCycleException {
        return this.target.followTransition(transition);
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        return this.target.getAllowedStateTransitions();
    }

    public boolean isLocked() throws DocumentException {
        return this.target.isLocked();
    }

    public String getLock() throws DocumentException {
        return this.target.getLock();
    }

    public void setLock(String key) throws DocumentException {
        this.target.setLock(key);
    }

    public String unlock() throws DocumentException {
        return this.target.unlock();
    }

    public boolean isVersion() {
        return false;
    }

    public Document getSourceDocument() throws DocumentException {
        return this.target;
    }

    public void checkIn(String label) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void checkIn(String label, String description) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void checkOut() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public boolean isCheckedOut() throws DocumentException {
        return this.target.isCheckedOut();
    }

    public void restore(String label) throws DocumentException {
        this.target.restore(label);
    }

    public List<String> getVersionsIds() throws DocumentException {
        return this.target.getVersionsIds();
    }

    public Document getVersion(String label) throws DocumentException {
        return this.target.getVersion(label);
    }

    public DocumentVersionIterator getVersions() throws DocumentException {
        return this.target.getVersions();
    }

    public DocumentVersion getLastVersion() throws DocumentException {
        return this.target.getLastVersion();
    }

    public boolean hasVersions() throws DocumentException {
        return this.target.hasVersions();
    }

    public Document resolvePath(String path) throws DocumentException {
        return this.proxy.resolvePath(path);
    }

    public Document getChild(String name) throws DocumentException {
        return this.proxy.getChild(name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        return this.proxy.getChildren();
    }

    public DocumentIterator getChildren(int start) throws DocumentException {
        return this.proxy.getChildren(start);
    }

    public List<String> getChildrenIds() throws DocumentException {
        return this.proxy.getChildrenIds();
    }

    public boolean hasChild(String name) throws DocumentException {
        return this.proxy.hasChild(name);
    }

    public boolean hasChildren() throws DocumentException {
        return this.proxy.hasChildren();
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        return this.proxy.addChild(name, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        this.proxy.orderBefore(src, dest);
    }

    public void removeChild(String name) throws DocumentException {
        this.proxy.removeChild(name);
    }

    public Document getTargetDocument() {
        return this.target;
    }

    public void setTargetDocument(Document target) throws DocumentException {
        ((SQLDocument)this.proxy).checkWritable();
        try {
            ((SQLDocument)this.proxy).getNode().setSingleProperty("ecm:proxyTargetId", (Serializable)((Object)target.getUUID()));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        this.target = target;
    }

    public boolean isPropertySet(String name) throws DocumentException {
        return this.target.isPropertySet(name);
    }

    public Property getProperty(String name) throws DocumentException {
        return this.target.getProperty(name);
    }

    public Collection<Property> getProperties() throws DocumentException {
        return this.target.getProperties();
    }

    public Iterator<Property> getPropertyIterator() throws DocumentException {
        return this.target.getPropertyIterator();
    }

    public Map<String, Object> exportFlatMap(String[] schemas) throws DocumentException {
        return this.target.exportFlatMap(schemas);
    }

    public Map<String, Map<String, Object>> exportMap(String[] schemas) throws DocumentException {
        return this.target.exportMap(schemas);
    }

    public Map<String, Object> exportMap(String schemaName) throws DocumentException {
        return this.target.exportMap(schemaName);
    }

    public void importFlatMap(Map<String, Object> map) throws DocumentException {
        this.target.importFlatMap(map);
    }

    public void importMap(Map<String, Map<String, Object>> map) throws DocumentException {
        this.target.importMap(map);
    }

    public List<String> getDirtyFields() {
        return this.target.getDirtyFields();
    }

    public Object getPropertyValue(String name) throws DocumentException {
        return this.target.getPropertyValue(name);
    }

    public String getString(String name) throws DocumentException {
        return this.target.getString(name);
    }

    public boolean getBoolean(String name) throws DocumentException {
        return this.target.getBoolean(name);
    }

    public long getLong(String name) throws DocumentException {
        return this.target.getLong(name);
    }

    public double getDouble(String name) throws DocumentException {
        return this.target.getDouble(name);
    }

    public Calendar getDate(String name) throws DocumentException {
        return this.target.getDate(name);
    }

    public Blob getContent(String name) throws DocumentException {
        return this.target.getContent(name);
    }

    public void setPropertyValue(String name, Object value) throws DocumentException {
        this.target.setPropertyValue(name, value);
    }

    public void setString(String name, String value) throws DocumentException {
        this.target.setString(name, value);
    }

    public void setBoolean(String name, boolean value) throws DocumentException {
        this.target.setBoolean(name, value);
    }

    public void setLong(String name, long value) throws DocumentException {
        this.target.setLong(name, value);
    }

    public void setDouble(String name, double value) throws DocumentException {
        this.target.setDouble(name, value);
    }

    public void setDate(String name, Calendar value) throws DocumentException {
        this.target.setDate(name, value);
    }

    public void setContent(String name, Blob value) throws DocumentException {
        this.target.setContent(name, value);
    }

    public void removeProperty(String name) throws DocumentException {
        this.target.removeProperty(name);
    }

    public Object getValue() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public boolean isNull() {
        throw new UnsupportedOperationException();
    }

    public void setNull() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object value) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.target + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocumentProxy) {
            return this.equals((SQLDocumentProxy)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentProxy other) {
        return this.proxy.equals(other.proxy) && this.target.equals(other.target);
    }

    public int hashCode() {
        return this.proxy.hashCode() + this.target.hashCode();
    }
}

