/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLComplexProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentListIterator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersionIterator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.versioning.DocumentVersion;
import org.nuxeo.ecm.core.versioning.DocumentVersionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDocumentLive
extends SQLComplexProperty
implements SQLDocument {
    private static final Log log = LogFactory.getLog(SQLDocumentLive.class);
    protected String lock;
    protected static final Map<String, String> systemPropNameMap = new HashMap<String, String>();

    protected SQLDocumentLive(Node node, ComplexType type, SQLSession session, boolean readonly) {
        super(node, type, session, readonly);
    }

    @Override
    public Property getACLProperty() throws DocumentException {
        return this.session.makeACLProperty(this.getNode());
    }

    public DocumentType getType() {
        return (DocumentType)this.type;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isFolder() {
        return this.type == null || ((DocumentType)this.type).isFolder();
    }

    public String getUUID() {
        return this.getNode().getId().toString();
    }

    public Document getParent() throws DocumentException {
        return this.session.getParent(this.getNode());
    }

    public String getPath() throws DocumentException {
        return this.session.getPath(this.getNode());
    }

    public Calendar getLastModified() {
        throw new UnsupportedOperationException("unused");
    }

    public boolean isProxy() {
        return false;
    }

    public Repository getRepository() {
        return this.session.getRepository();
    }

    public void remove() throws DocumentException {
        this.session.remove(this.getNode());
    }

    public void save() throws DocumentException {
        this.session.save();
    }

    public boolean isDirty() throws DocumentException {
        Boolean value = (Boolean)this.getProperty("ecm:dirty").getValue();
        return value == null ? true : value;
    }

    public void setDirty(boolean value) throws DocumentException {
        this.setBoolean("ecm:dirty", value);
    }

    public void readDocumentPart(DocumentPart dp) throws Exception {
        for (org.nuxeo.ecm.core.api.model.Property property : dp) {
            property.init((Serializable)this.getPropertyValue(property.getName()));
        }
    }

    public void writeDocumentPart(DocumentPart dp) throws Exception {
        for (org.nuxeo.ecm.core.api.model.Property property : dp) {
            String name = property.getName();
            Serializable value = property.getValueForWrite();
            try {
                this.setPropertyValue(name, value);
            }
            catch (SQLDocumentVersion.VersionNotModifiableException e) {
                if (!name.startsWith("dc:")) {
                    throw e;
                }
                Object oldValue = this.getPropertyValue(name);
                if (SQLDocumentLive.same(value, oldValue) || value != null && oldValue != null && SQLDocumentLive.sameArray(value, oldValue)) continue;
                throw e;
            }
        }
        SQLDocumentLive.clearDirtyFlags((org.nuxeo.ecm.core.api.model.Property)dp);
    }

    protected static boolean same(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    protected static boolean sameArray(Object a, Object b) {
        Class<?> acls = a.getClass();
        Class<?> bcls = b.getClass();
        if (!acls.isArray() || !bcls.isArray() || Array.getLength(a) != Array.getLength(b)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(a); ++i) {
            if (SQLDocumentLive.same(Array.get(a, i), Array.get(b, i))) continue;
            return false;
        }
        return true;
    }

    protected static void clearDirtyFlags(org.nuxeo.ecm.core.api.model.Property property) {
        if (property.isContainer()) {
            for (org.nuxeo.ecm.core.api.model.Property p : property) {
                SQLDocumentLive.clearDirtyFlags(p);
            }
        }
        property.clearDirtyFlags();
    }

    public <T extends Serializable> void setSystemProp(String name, T value) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        this.getProperty(propertyName).setValue(value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        Object value = this.getProperty(propertyName).getValue();
        if (value == null) {
            if (type == Boolean.class) {
                value = Boolean.FALSE;
            } else if (type == Long.class) {
                value = 0L;
            }
        }
        return (T)((Serializable)value);
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        try {
            return this.getString("ecm:lifeCyclePolicy");
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get policy", (Throwable)e);
        }
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        try {
            this.setString("ecm:lifeCyclePolicy", policy);
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set policy", (Throwable)e);
        }
    }

    public String getCurrentLifeCycleState() throws LifeCycleException {
        try {
            return this.getString("ecm:lifeCycleState");
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get state", (Throwable)e);
        }
    }

    public void setCurrentLifeCycleState(String state) throws LifeCycleException {
        try {
            this.setString("ecm:lifeCycleState", state);
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set state", (Throwable)e);
        }
    }

    public boolean followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
        return true;
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getCurrentLifeCycleState());
    }

    public boolean isLocked() throws DocumentException {
        return this.getLock() != null;
    }

    public String getLock() throws DocumentException {
        if (this.lock != null) {
            return this.lock == "" ? null : this.lock;
        }
        String l = this.getString("ecm:lock");
        this.lock = l == null ? "" : l;
        return l;
    }

    public void setLock(String key) throws DocumentException {
        if (key == null) {
            throw new IllegalArgumentException("Lock key cannot be null");
        }
        if (this.isLocked()) {
            throw new DocumentException("Document already locked");
        }
        this.setString("ecm:lock", key);
        this.lock = key;
    }

    public String unlock() throws DocumentException {
        String l = this.getLock();
        this.setString("ecm:lock", null);
        this.lock = "";
        return l;
    }

    public boolean isVersion() {
        return false;
    }

    public Document getSourceDocument() throws DocumentException {
        return this;
    }

    public void checkIn(String label) throws DocumentException {
        this.checkIn(label, null);
    }

    public void checkIn(String label, String description) throws DocumentException {
        this.session.checkIn(this.getNode(), label, description);
    }

    public void checkOut() throws DocumentException {
        this.session.checkOut(this.getNode());
    }

    public boolean isCheckedOut() throws DocumentException {
        return !this.getBoolean("ecm:isCheckedIn");
    }

    public void restore(String label) throws DocumentException {
        this.session.restoreByLabel(this.getNode(), label);
    }

    public List<String> getVersionsIds() throws DocumentException {
        Collection<DocumentVersion> versions = this.session.getVersions(this.getNode());
        ArrayList<String> ids = new ArrayList<String>(versions.size());
        for (DocumentVersion version : versions) {
            ids.add(version.getUUID());
        }
        return ids;
    }

    public Document getVersion(String label) throws DocumentException {
        return this.session.getVersionByLabel(this.getNode(), label);
    }

    public DocumentVersionIterator getVersions() throws DocumentException {
        return new SQLDocumentVersionIterator(this.session.getVersions(this.getNode()));
    }

    public DocumentVersion getLastVersion() throws DocumentException {
        return this.session.getLastVersion(this.getNode());
    }

    public boolean hasVersions() throws DocumentException {
        log.error((Object)"hasVersions unimplemented, returning false");
        return false;
    }

    public Document resolvePath(String path) throws DocumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length() == 0) {
            return this;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.session.resolvePath(this.getNode(), path);
    }

    public Document getChild(String name) throws DocumentException {
        return this.session.getChild(this.getNode(), name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        return this.getChildren(0);
    }

    public DocumentIterator getChildren(int start) throws DocumentException {
        if (!this.isFolder()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        List<Document> children = this.session.getChildren(this.getNode());
        if (start < 0) {
            throw new IllegalArgumentException(String.valueOf(start));
        }
        if (start >= children.size()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        return new SQLDocumentListIterator(children.subList(start, children.size()));
    }

    public List<String> getChildrenIds() throws DocumentException {
        if (!this.isFolder()) {
            return Collections.emptyList();
        }
        List<Document> children = this.session.getChildren(this.getNode());
        ArrayList<String> ids = new ArrayList<String>(children.size());
        for (Document child : children) {
            ids.add(child.getUUID());
        }
        return ids;
    }

    public boolean hasChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChild(this.getNode(), name);
    }

    public boolean hasChildren() throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChildren(this.getNode());
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        return this.session.addChild(this.getNode(), name, null, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        SQLDocument destDoc;
        SQLDocument srcDoc = (SQLDocument)this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = (SQLDocument)this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.getNode(), srcDoc.getNode(), destDoc == null ? null : destDoc.getNode());
    }

    public void removeChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return;
        }
        Document doc = this.getChild(name);
        doc.remove();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ',' + this.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocumentLive) {
            return this.equals((SQLDocumentLive)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentLive other) {
        return this.getNode().equals((Object)other.getNode());
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    static {
        systemPropNameMap.put("WfinProgress", "ecm:wfInProgress");
        systemPropNameMap.put("WfIncOption", "ecm:wfIncOption");
        systemPropNameMap.put("binaryText", "ecm:binaryText");
    }
}

