/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Reference;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.servlet.Servlet;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.ConnectionSpecImpl;
import org.nuxeo.ecm.core.storage.sql.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCBackend;
import org.nuxeo.ecm.core.storage.sql.net.BinaryManagerClient;
import org.nuxeo.ecm.core.storage.sql.net.BinaryManagerServlet;
import org.nuxeo.ecm.core.storage.sql.net.MapperServlet;
import org.nuxeo.ecm.core.storage.sql.net.NetBackend;
import org.nuxeo.ecm.core.storage.sql.net.NetServer;
import org.nuxeo.runtime.api.Framework;

public class RepositoryImpl
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryImpl.class);
    public static final String SERVER_PATH_VCS = "vcs";
    public static final String SERVER_PATH_BINARY = "binary";
    protected final RepositoryDescriptor repositoryDescriptor;
    protected final MultiThreadedHttpConnectionManager connectionManager;
    protected final HttpClient httpClient;
    protected final SchemaManager schemaManager;
    protected final EventService eventService;
    protected final BinaryManager binaryManager;
    private final RepositoryBackend backend;
    private final Collection<SessionImpl> sessions;
    private Model model;
    private Mapper clusterMapper;
    private long clusterLastInvalidationTimeMillis;
    private boolean serverStarted;
    private boolean binaryServerStarted;
    private Reference reference;

    public RepositoryImpl(RepositoryDescriptor repositoryDescriptor) throws StorageException {
        this.repositoryDescriptor = repositoryDescriptor;
        this.sessions = new CopyOnWriteArrayList<SessionImpl>();
        try {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        try {
            this.eventService = (EventService)Framework.getService(EventService.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(20);
        params.setMaxTotalConnections(20);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.binaryManager = this.createBinaryManager();
        this.backend = this.createBackend();
        this.createServer();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected BinaryManager createBinaryManager() throws StorageException {
        try {
            Class<? extends BinaryManager> klass = this.repositoryDescriptor.binaryManagerClass;
            if (klass == null) {
                klass = DefaultBinaryManager.class;
            }
            BinaryManager binaryManager = klass.newInstance();
            binaryManager.initialize(this.repositoryDescriptor);
            if (this.repositoryDescriptor.binaryManagerConnect) {
                List<RepositoryDescriptor.ServerDescriptor> connect = this.repositoryDescriptor.connect;
                if (connect.isEmpty() || connect.get((int)0).disabled) {
                    log.error((Object)"Repository descriptor specifies binaryManager connect without a global connect");
                } else {
                    binaryManager = new BinaryManagerClient(binaryManager, this.httpClient);
                    binaryManager.initialize(this.repositoryDescriptor);
                }
            }
            if (this.repositoryDescriptor.binaryManagerListen) {
                RepositoryDescriptor.ServerDescriptor serverDescriptor = this.repositoryDescriptor.listen;
                if (serverDescriptor == null || serverDescriptor.disabled) {
                    log.error((Object)"Repository descriptor specifies binaryManager listen without a global listen");
                } else {
                    BinaryManagerServlet servlet = new BinaryManagerServlet(binaryManager);
                    String servletName = BinaryManagerServlet.getName(binaryManager);
                    String url = NetServer.add(serverDescriptor, servletName, (Servlet)servlet, SERVER_PATH_BINARY);
                    log.info((Object)String.format("VCS server for binary manager of repository '%s' started on: %s", this.repositoryDescriptor.name, url));
                    this.binaryServerStarted = true;
                }
            }
            return binaryManager;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected RepositoryBackend createBackend() throws StorageException {
        Class backendClass = this.repositoryDescriptor.backendClass;
        List<RepositoryDescriptor.ServerDescriptor> connect = this.repositoryDescriptor.connect;
        if (backendClass == null) {
            backendClass = !connect.isEmpty() ? NetBackend.class : JDBCBackend.class;
        } else if (!connect.isEmpty()) {
            log.error((Object)"Repository descriptor specifies both backendClass and connect, only the backend will be used.");
        }
        try {
            RepositoryBackend backend = backendClass.newInstance();
            backend.initialize(this);
            return backend;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected void createServer() {
        RepositoryDescriptor.ServerDescriptor serverDescriptor = this.repositoryDescriptor.listen;
        if (serverDescriptor != null && !serverDescriptor.disabled) {
            MapperServlet servlet = new MapperServlet(this.repositoryDescriptor.name);
            String servletName = MapperServlet.getName(this.repositoryDescriptor.name);
            String url = NetServer.add(this.repositoryDescriptor.listen, servletName, (Servlet)servlet, SERVER_PATH_VCS);
            log.info((Object)String.format("VCS server for repository '%s' started on: %s", this.repositoryDescriptor.name, url));
            this.serverStarted = true;
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public SessionImpl getConnection() throws StorageException {
        return this.getConnection(null);
    }

    public synchronized SessionImpl getConnection(ConnectionSpec connectionSpec) throws StorageException {
        boolean initialized;
        assert (connectionSpec == null || connectionSpec instanceof ConnectionSpecImpl);
        Credentials credentials = connectionSpec == null ? null : ((ConnectionSpecImpl)connectionSpec).getCredentials();
        boolean bl = initialized = this.model != null;
        if (!initialized) {
            log.debug((Object)"Initializing");
            ModelSetup modelSetup = new ModelSetup();
            modelSetup.repositoryDescriptor = this.repositoryDescriptor;
            modelSetup.schemaManager = this.schemaManager;
            this.backend.initializeModelSetup(modelSetup);
            this.model = new Model(modelSetup);
            this.backend.initializeModel(this.model);
        }
        SessionPathResolver pathResolver = new SessionPathResolver();
        Mapper mapper = this.backend.newMapper(this.model, pathResolver);
        if (!initialized) {
            mapper.createDatabase();
            if (this.repositoryDescriptor.clusteringEnabled) {
                log.info((Object)("Clustering enabled with " + this.repositoryDescriptor.clusteringDelay + " ms delay for repository: " + this.getName()));
                this.clusterMapper = mapper;
                this.clusterMapper.createClusterNode();
                this.processClusterInvalidationsNext();
                mapper = this.backend.newMapper(this.model, pathResolver);
            }
        }
        SessionImpl session = this.newSession(mapper, credentials);
        pathResolver.setSession(session);
        this.sessions.add(session);
        return session;
    }

    protected SessionImpl newSession(Mapper mapper, Credentials credentials) throws StorageException {
        mapper = new CachingMapper(mapper);
        return new SessionImpl(this, this.model, mapper, credentials);
    }

    public ResourceAdapterMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public RecordFactory getRecordFactory() {
        throw new UnsupportedOperationException();
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws StorageException {
        String servletName;
        for (SessionImpl session : this.sessions) {
            if (!session.isLive()) continue;
            session.closeSession();
        }
        this.sessions.clear();
        if (this.clusterMapper != null) {
            Mapper i$ = this.clusterMapper;
            synchronized (i$) {
                try {
                    this.clusterMapper.removeClusterNode();
                }
                catch (StorageException e) {
                    log.error((Object)e.getMessage(), (Throwable)((Object)e));
                }
                this.clusterMapper.close();
            }
            this.clusterMapper = null;
        }
        this.model = null;
        if (this.serverStarted) {
            servletName = MapperServlet.getName(this.repositoryDescriptor.name);
            NetServer.remove(this.repositoryDescriptor.listen, servletName);
            this.serverStarted = false;
        }
        if (this.binaryServerStarted) {
            servletName = BinaryManagerServlet.getName(this.binaryManager);
            NetServer.remove(this.repositoryDescriptor.listen, servletName);
            this.binaryServerStarted = false;
        }
        this.backend.shutdown();
        this.connectionManager.shutdown();
    }

    protected synchronized void closeAllSessions() throws StorageException {
        for (SessionImpl session : this.sessions) {
            if (!session.isLive()) continue;
            session.closeSession();
        }
        this.sessions.clear();
    }

    public String getName() {
        return this.repositoryDescriptor.name;
    }

    public int getActiveSessionsCount() {
        return this.sessions.size();
    }

    public int clearCaches() {
        int n = 0;
        for (SessionImpl session : this.sessions) {
            n += session.clearCaches();
        }
        return n;
    }

    public void processClusterInvalidationsNext() {
        this.clusterLastInvalidationTimeMillis = System.currentTimeMillis() - this.repositoryDescriptor.clusteringDelay - 1L;
    }

    protected void closeSession(SessionImpl session) {
        this.sessions.remove(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(Invalidations invalidations, SessionImpl fromSession) throws StorageException {
        for (SessionImpl session : this.sessions) {
            if (session == fromSession) continue;
            session.invalidate(invalidations);
        }
        if (this.clusterMapper != null) {
            Mapper mapper = this.clusterMapper;
            synchronized (mapper) {
                this.clusterMapper.insertClusterInvalidations(invalidations);
            }
        }
        this.sendInvalidationEvent(invalidations, true, fromSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveClusterInvalidations(SessionImpl fromSession) throws StorageException {
        if (this.clusterMapper != null) {
            Invalidations invalidations;
            Mapper mapper = this.clusterMapper;
            synchronized (mapper) {
                if (this.clusterLastInvalidationTimeMillis + this.repositoryDescriptor.clusteringDelay > System.currentTimeMillis()) {
                    return;
                }
                invalidations = this.clusterMapper.getClusterInvalidations();
                this.clusterLastInvalidationTimeMillis = System.currentTimeMillis();
            }
            if (!invalidations.isEmpty()) {
                for (SessionImpl session : this.sessions) {
                    session.invalidate(invalidations);
                }
                this.sendInvalidationEvent(invalidations, false, fromSession);
            }
        }
    }

    protected void sendInvalidationEvent(Invalidations invalidations, boolean local, SessionImpl session) {
        if (!this.repositoryDescriptor.sendInvalidationEvents) {
            return;
        }
        HashSet<String> modifiedDocIds = new HashSet<String>();
        HashSet<String> modifiedParentIds = new HashSet<String>();
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                String docId;
                String id = (String)((Object)rowId.id);
                try {
                    docId = (String)((Object)session.getContainingDocument((Serializable)((Object)id)));
                }
                catch (StorageException e) {
                    log.error((Object)("Cannot get containing document for: " + id), (Throwable)((Object)e));
                    docId = null;
                }
                if (docId == null) continue;
                if ("__PARENT__".equals(rowId.tableName)) {
                    if (docId.equals(id)) {
                        modifiedParentIds.add(docId);
                        continue;
                    }
                    modifiedDocIds.add(docId);
                    continue;
                }
                modifiedDocIds.add(docId);
            }
        }
        EventContextImpl ctx = new EventContextImpl(null, null);
        ctx.setRepositoryName(this.getName());
        ctx.setProperty("modifiedDocIds", modifiedDocIds);
        ctx.setProperty("modifiedParentIds", modifiedParentIds);
        ctx.setProperty("local", (Serializable)Boolean.valueOf(local));
        EventImpl event = new EventImpl("vcsInvalidations", (EventContext)ctx);
        try {
            this.eventService.fireEvent((Event)event);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to send invalidation event: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public static class SessionPathResolver
    implements Session.PathResolver {
        private Session session;

        protected void setSession(Session session) {
            this.session = session;
        }

        public Serializable getIdForPath(String path) throws StorageException {
            Node node = this.session.getNodeByPath(path, null);
            return node == null ? null : node.getId();
        }
    }
}

