/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerDescriptor;
import org.nuxeo.ecm.core.storage.sql.BinaryScrambler;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class DefaultBinaryManager
implements BinaryManager {
    private static final Log log = LogFactory.getLog(DefaultBinaryManager.class);
    public static final String DEFAULT_DIGEST = "MD5";
    public static final int DEFAULT_DEPTH = 2;
    public static final String DEFAULT_PATH = "binaries";
    public static final String DATA = "data";
    public static final String TMP = "tmp";
    public static final String CONFIG_FILE = "config.xml";
    protected File storageDir;
    protected File tmpDir;
    protected BinaryManagerDescriptor descriptor;
    public static final int MIN_BUF_SIZE = 8192;
    public static final int MAX_BUF_SIZE = 65536;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public void initialize(RepositoryDescriptor repositoryDescriptor) throws IOException {
        File base;
        String path = repositoryDescriptor.binaryStorePath;
        if (path == null || path.trim().length() == 0) {
            path = DEFAULT_PATH;
        }
        if ((path = path.trim()).startsWith("/") || path.startsWith("\\") || path.contains("://") || path.contains(":\\")) {
            base = new File(path);
        } else {
            String home = Framework.getRuntime().getHome().getPath();
            if (home.endsWith("/") || home.endsWith("\\")) {
                home = home.substring(0, home.length() - 1);
            }
            base = new File(home, path);
        }
        log.info((Object)("Repository '" + repositoryDescriptor.name + "' using " + (this.getClass().equals(DefaultBinaryManager.class) ? "" : this.getClass().getSimpleName() + " and ") + "binary store: " + base));
        this.storageDir = new File(base, DATA);
        this.tmpDir = new File(base, TMP);
        this.storageDir.mkdirs();
        this.tmpDir.mkdirs();
        this.descriptor = this.getDescriptor(new File(base, CONFIG_FILE));
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    protected BinaryManagerDescriptor getDescriptor(File configFile) throws IOException {
        BinaryManagerDescriptor desc;
        if (configFile.exists()) {
            XMap xmap = new XMap();
            xmap.register(BinaryManagerDescriptor.class);
            try {
                desc = (BinaryManagerDescriptor)xmap.load((InputStream)new FileInputStream(configFile));
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        } else {
            desc = new BinaryManagerDescriptor();
            desc.digest = DEFAULT_DIGEST;
            desc.depth = 2;
            desc.write(configFile);
        }
        return desc;
    }

    protected BinaryScrambler getBinaryScrambler() {
        return NullBinaryScrambler.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binary getBinary(InputStream in) throws IOException {
        String digest;
        File tmp = File.createTempFile("create_", ".tmp", this.tmpDir);
        tmp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmp);
        try {
            digest = this.storeAndDigest(in, out);
        }
        finally {
            ((OutputStream)out).close();
        }
        File file = this.getFileForDigest(digest, true);
        tmp.renameTo(file);
        tmp.delete();
        if (!file.exists()) {
            throw new IOException("Could not create file: " + file);
        }
        return this.getBinaryScrambler().getUnscrambledBinary(file, digest);
    }

    public Binary getBinary(String digest) {
        File file = this.getFileForDigest(digest, false);
        if (file == null || !file.exists()) {
            return null;
        }
        return this.getBinaryScrambler().getUnscrambledBinary(file, digest);
    }

    public File getFileForDigest(String digest, boolean createDir) {
        int depth = this.descriptor.depth;
        if (digest.length() < 2 * depth) {
            return null;
        }
        StringBuilder buf = new StringBuilder(3 * depth - 1);
        for (int i = 0; i < depth; ++i) {
            if (i != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(digest.substring(2 * i, 2 * i + 2));
        }
        File dir = new File(this.storageDir, buf.toString());
        if (createDir) {
            dir.mkdirs();
        }
        return new File(dir, digest);
    }

    protected String storeAndDigest(InputStream in, OutputStream out) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(this.descriptor.digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int size = in.available();
        if (size == 0) {
            size = 65536;
        } else if (size < 8192) {
            size = 8192;
        } else if (size > 65536) {
            size = 65536;
        }
        byte[] buf = new byte[size];
        BinaryScrambler scrambler = this.getBinaryScrambler();
        while ((n = in.read(buf)) != -1) {
            scrambler.scrambleBuffer(buf, 0, n);
            digest.update(buf, 0, n);
            out.write(buf, 0, n);
        }
        out.flush();
        return DefaultBinaryManager.toHexString(digest.digest());
    }

    public static String toHexString(byte[] data) {
        StringBuilder buf = new StringBuilder(2 * data.length);
        for (byte b : data) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    public static class ScrambledFileInputStream
    extends InputStream {
        protected final InputStream is;
        protected final BinaryScrambler scrambler;
        protected final byte[] onebyte = new byte[1];

        protected ScrambledFileInputStream(File file, BinaryScrambler scrambler) throws IOException {
            this.is = new FileInputStream(file);
            this.scrambler = scrambler;
            scrambler.reset();
        }

        public int read() throws IOException {
            int b = this.is.read();
            if (b != -1) {
                this.onebyte[0] = (byte)b;
                this.scrambler.unscrambleBuffer(this.onebyte, 0, 1);
                b = this.onebyte[0];
            }
            return b;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.is.read(b, off, len);
            if (n != -1) {
                this.scrambler.unscrambleBuffer(b, off, n);
            }
            return n;
        }

        public long skip(long n) throws IOException {
            n = this.is.skip(n);
            this.scrambler.skip(n);
            return n;
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
        }
    }

    public static class ScrambledStreamSource
    extends FileSource {
        protected final BinaryScrambler scrambler;

        public ScrambledStreamSource(File file, BinaryScrambler scrambler) {
            super(file);
            this.scrambler = scrambler;
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public InputStream getStream() throws IOException {
            return new ScrambledFileInputStream(this.file, this.scrambler);
        }
    }

    public static class ScrambledBinary
    extends Binary {
        private static final long serialVersionUID = 1L;
        private final File file;
        protected final BinaryScrambler scrambler;

        public ScrambledBinary(File file, String digest, BinaryScrambler scrambler) {
            super(file, digest);
            this.file = file;
            this.scrambler = scrambler;
        }

        public InputStream getStream() throws IOException {
            return new ScrambledFileInputStream(this.file, this.scrambler);
        }

        public StreamSource getStreamSource() {
            return new ScrambledStreamSource(this.file, this.scrambler);
        }
    }

    public static class NullBinaryScrambler
    implements BinaryScrambler {
        public static final BinaryScrambler INSTANCE = new NullBinaryScrambler();

        public void scrambleBuffer(byte[] buf, int off, int n) {
        }

        public void unscrambleBuffer(byte[] buf, int off, int n) {
        }

        public Binary getUnscrambledBinary(File file, String digest) {
            return new Binary(file, digest);
        }

        public void skip(long n) {
        }

        public void reset() {
        }
    }
}

