/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class BooleanType
extends PrimitiveType {
    public static final String ID = "boolean";
    public static final BooleanType INSTANCE = new BooleanType();
    private static final long serialVersionUID = 6734833141342781661L;

    private BooleanType() {
        super(ID);
    }

    public boolean validate(Object object) {
        return object instanceof Boolean;
    }

    public Object convert(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.parseBoolean((String)value);
    }

    public Object decode(String str) {
        if (str == null) {
            return null;
        }
        return Boolean.parseBoolean(str);
    }

    public String encode(Object value) {
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        return value != null ? (String)value : "";
    }

    public Object newInstance() {
        return false;
    }

    protected Object readResolve() {
        return INSTANCE;
    }
}

