/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTypes {
    private static final Map<Class<?>, Type> class2Types = new Hashtable();
    private static final Map<Type, Class<?>> types2Class = new Hashtable();

    private JavaTypes() {
    }

    public static boolean isList(Object object) {
        return object instanceof List;
    }

    public static boolean isComplex(Object object) {
        return object instanceof Map;
    }

    public static Type getType(Class<?> klass) {
        return class2Types.get(klass);
    }

    public static Class<?> getClass(Type type) {
        return types2Class.get(type);
    }

    public static Class<?> getPrimitiveClass(Type type) {
        Class<?> k = types2Class.get(type);
        if (k == Long.class) {
            return Long.TYPE;
        }
        if (k == Integer.class) {
            return Integer.TYPE;
        }
        if (k == Double.class) {
            return Double.TYPE;
        }
        if (k == Float.class) {
            return Float.TYPE;
        }
        if (k == Short.class) {
            return Short.TYPE;
        }
        if (k == Byte.class) {
            return Byte.TYPE;
        }
        if (k == Character.class) {
            return Character.TYPE;
        }
        return k;
    }

    public static void bind(Type type, Class<?> klass) {
        class2Types.put(klass, type);
        types2Class.put(type, klass);
    }

    static {
        JavaTypes.bind(StringType.INSTANCE, String.class);
        JavaTypes.bind(LongType.INSTANCE, Long.class);
        JavaTypes.bind(IntegerType.INSTANCE, Integer.class);
        JavaTypes.bind(DoubleType.INSTANCE, Double.class);
        JavaTypes.bind(BooleanType.INSTANCE, Boolean.class);
        JavaTypes.bind(BinaryType.INSTANCE, InputStream.class);
        JavaTypes.bind(DateType.INSTANCE, Date.class);
        JavaTypes.bind(DateType.INSTANCE, Calendar.class);
    }
}

