/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.ArrayList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.ecm.core.schema.types.TypeHelper;
import org.nuxeo.ecm.core.schema.types.ValueConverter;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType
implements Type {
    public static final Type[] EMPTY_SUPERTYPES = new Type[0];
    public static final int F_READONLY = 1;
    public static final int F_NOTNULL = 2;
    private static final long serialVersionUID = -7902736654482518683L;
    protected final String name;
    protected final TypeRef<?> superType;
    protected final String schema;
    protected int flags;
    protected ValueConverter converter;
    protected TypeHelper helper;

    protected AbstractType(TypeRef<? extends Type> superType, String schema, String name) {
        assert (schema != null);
        assert (name != null);
        this.name = name;
        this.schema = schema;
        this.superType = superType == null ? TypeRef.NULL : superType;
    }

    @Override
    public TypeRef<? extends Type> getRef() {
        return new TypeRef<AbstractType>(this.schema, this.name, this);
    }

    @Override
    public TypeHelper getHelper() {
        if (this.helper == null) {
            try {
                SchemaManager sm = (SchemaManager)Framework.getService(SchemaManager.class);
                this.helper = sm.getHelper(this.schema, this.name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.helper;
    }

    @Override
    public Type getSuperType() {
        return this.superType.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public Schema getSchema() {
        return ((TypeProvider)Framework.getLocalService(TypeProvider.class)).getSchema(this.schema);
    }

    @Override
    public boolean isSuperTypeOf(Type type) {
        Type t = type;
        do {
            if (this != t) continue;
            return true;
        } while ((t = t.getSuperType()) != null);
        return false;
    }

    public boolean isAny() {
        return false;
    }

    @Override
    public Type[] getTypeHierarchy() {
        Type type = this.getSuperType();
        if (type == null) {
            return EMPTY_SUPERTYPES;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        while (type != null) {
            types.add(type);
            type = type.getSuperType();
        }
        return types.toArray(new Type[types.size()]);
    }

    @Override
    public boolean isSimpleType() {
        return false;
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isAnyType() {
        return false;
    }

    @Override
    public boolean isCompositeType() {
        return false;
    }

    @Override
    public boolean isNotNull() {
        return this.isFlagSet(2);
    }

    @Override
    public boolean isReadOnly() {
        return this.isFlagSet(1);
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        return object != null || !this.isNotNull();
    }

    public void setNotNull(boolean val) {
        if (val) {
            this.setFlags(2);
        } else {
            this.clearFlags(2);
        }
    }

    public void setReadOnly(boolean val) {
        if (val) {
            this.setFlags(1);
        } else {
            this.clearFlags(1);
        }
    }

    protected final void setFlags(int flags) {
        this.flags |= flags;
    }

    protected final void clearFlags(int flags) {
        this.flags &= ~flags;
    }

    protected final boolean isFlagSet(int flags) {
        return (this.flags & flags) == flags;
    }

    @Override
    public Object decode(String string) {
        return null;
    }

    @Override
    public String encode(Object object) {
        return null;
    }

    @Override
    public Object newInstance() {
        return null;
    }
}

