/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class PrefetchInfo
implements Serializable {
    private static final long serialVersionUID = -6495547095819614741L;
    private static final Log log = LogFactory.getLog(PrefetchInfo.class);
    private final String expr;
    private transient Field[] fields;
    private transient Schema[] schemas;

    public PrefetchInfo(String expr) {
        assert (expr != null);
        this.expr = expr;
    }

    public Schema[] getSchemas() {
        if (this.schemas == null && this.expr != null) {
            this.parseExpression();
        }
        return this.schemas;
    }

    public Field[] getFields() {
        if (this.fields == null && this.expr != null) {
            this.parseExpression();
        }
        return this.fields;
    }

    private void parseExpression() {
        SchemaManager typeMgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        StringTokenizer st = new StringTokenizer(this.expr, " \t\n\r,");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int len = tok.length();
            if (len <= 0) continue;
            int p = tok.indexOf(58);
            if (p > -1) {
                Field field = typeMgr.getField(tok);
                if (field != null) {
                    fields.add(field);
                    continue;
                }
                log.error((Object)("Field  '" + tok + "' not found for prefetching"));
                continue;
            }
            p = tok.indexOf(46);
            if (p > -1) {
                Field field;
                String schemaName = tok.substring(0, p);
                String fieldName = tok.substring(p + 1);
                Schema schema = typeMgr.getSchema(schemaName);
                if (schema != null && (field = schema.getField(fieldName)) != null) {
                    fields.add(field);
                    continue;
                }
                log.error((Object)("Field '" + tok + "' could not be resolved for prefetching"));
                continue;
            }
            Schema schema = typeMgr.getSchema(tok);
            if (schema != null) {
                schemas.add(schema);
                continue;
            }
            log.error((Object)("Schema '" + tok + "' not found for prefetching"));
        }
        this.fields = fields.toArray(new Field[fields.size()]);
        this.schemas = schemas.toArray(new Schema[schemas.size()]);
    }
}

