/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTypeImpl
extends CompositeTypeImpl
implements DocumentType {
    public static final int T_DOCUMENT = 256;
    public static final int T_FOLDER = 512;
    public static final int T_ORDERED = 1024;
    private static final long serialVersionUID = 4257192861843860742L;
    private static final String[] EMPTY_FACETS = new String[0];
    protected int unstructured;
    protected String[] declaredFacets = EMPTY_FACETS;
    protected Set<String> facets;
    protected String[] subtypes;
    protected PrefetchInfo prefetchInfo;

    public DocumentTypeImpl(DocumentType superType, String name) {
        this(superType == null ? null : superType.getRef(), name, (String[])null, (String[])null, 0);
    }

    public DocumentTypeImpl(DocumentType superType, String name, String[] declaredSchemas) {
        this(superType == null ? null : superType.getRef(), name, declaredSchemas, null, 0);
    }

    public DocumentTypeImpl(DocumentType superType, String name, String[] declaredSchemas, String[] declaredFacets) {
        this(superType == null ? null : superType.getRef(), name, declaredSchemas, declaredFacets, 0);
    }

    public DocumentTypeImpl(TypeRef<DocumentType> superType, String name) {
        this(superType, name, (String[])null, (String[])null, 0);
    }

    public DocumentTypeImpl(TypeRef<DocumentType> superType, String name, String[] declaredSchemas) {
        this(superType, name, declaredSchemas, null, 0);
    }

    public DocumentTypeImpl(TypeRef<DocumentType> superType, String name, String[] declaredSchemas, String[] facets) {
        this(superType, name, declaredSchemas, facets, 0);
    }

    public DocumentTypeImpl(TypeRef<DocumentType> superType, String name, String[] declaredSchemas, String[] facets, int type) {
        super(superType, "@doctypes", name, declaredSchemas);
        if (type != 0) {
            this.setFlags(type);
        } else {
            DocumentType stype = (DocumentType)this.superType.get();
            if (stype != null) {
                if (stype.isOrdered()) {
                    this.setFlags(1536);
                } else if (stype.isFolder()) {
                    this.setFlags(512);
                } else {
                    this.setFlags(256);
                }
            } else {
                this.setFlags(256);
            }
        }
        this.declaredFacets = facets == null ? EMPTY_FACETS : facets;
        this.subtypes = null;
    }

    @Override
    public void setPrefetchInfo(PrefetchInfo prefetchInfo) {
        this.prefetchInfo = prefetchInfo;
    }

    @Override
    public PrefetchInfo getPrefetchInfo() {
        return this.prefetchInfo;
    }

    @Override
    public boolean isUnstructured() {
        if (this.unstructured == 0) {
            this.unstructured = this.hasSchemas() ? 1 : 2;
        }
        return this.unstructured == 2;
    }

    @Override
    public boolean isFile() {
        return !this.getFacets().contains("Folderish");
    }

    @Override
    public boolean isFolder() {
        return this.getFacets().contains("Folderish");
    }

    @Override
    public boolean isOrdered() {
        Set<String> facets = this.getFacets();
        return facets.contains("Orderable");
    }

    @Override
    public Set<String> getFacets() {
        if (this.facets == null) {
            this.facets = this.buildFacets();
        }
        return this.facets;
    }

    @Override
    public void addSchemas(String[] schemas) {
        if (schemas != null) {
            for (String schema : schemas) {
                this.addSchema(schema);
            }
        }
    }

    @Override
    public void setDeclaredFacets(String[] facets) {
        this.declaredFacets = facets == null ? EMPTY_FACETS : facets;
        this.facets = null;
    }

    protected Set<String> buildFacets() {
        Set<String> facets = new HashSet<String>();
        DocumentTypeImpl stype = (DocumentTypeImpl)this.superType.get();
        if (stype == null) {
            facets.addAll(Arrays.asList(this.declaredFacets));
        } else {
            Set<String> inheritedFacets = stype.buildFacets();
            if (this.declaredFacets.length == 0) {
                facets = inheritedFacets;
            } else {
                for (String facet : inheritedFacets) {
                    facets.add(facet);
                }
                facets.addAll(Arrays.asList(this.declaredFacets));
            }
        }
        return facets;
    }

    @Override
    public TypeRef<DocumentType> getRef() {
        return new TypeRef<DocumentType>(this.schema, this.name, this);
    }

    @Override
    public String[] getChildrenTypes() {
        return this.subtypes;
    }

    @Override
    public void setChildrenTypes(String[] subTypes) {
        this.subtypes = subTypes;
    }

    @Override
    public DocumentType[] getResolvedChildrenTypes() {
        SchemaManager mgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        if (this.subtypes != null) {
            DocumentType[] result = new DocumentType[this.subtypes.length];
            for (int i = 0; i < this.subtypes.length; ++i) {
                result[i] = mgr.getDocumentType(this.subtypes[i]);
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean isChildTypeAllowed(String name) {
        if (this.subtypes != null) {
            for (String subtype : this.subtypes) {
                if (!subtype.equals(name)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

