/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SimplePrincipal;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.UnboundEventContext;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfoCallbackHandler;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoSecuredRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.LoginResponseHandler;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationPluginDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.OpenUrlDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoAuthenticationFilter
implements Filter {
    public static final String DEFAULT_START_PAGE = "nxstartup.faces";
    protected static final String LOGIN_DOMAIN = "nuxeo-ecm-web";
    protected static final String XMLHTTP_REQUEST_TYPE = "XMLHttpRequest";
    protected static final String LOGIN_JMS_CATEGORY = "NuxeoAuthentication";
    private static final Log log = LogFactory.getLog(NuxeoAuthenticationFilter.class);
    private static String anonymous;
    protected final boolean avoidReauthenticate = true;
    protected PluggableAuthenticationService service;
    protected List<String> unAuthenticatedURLPrefix;
    protected boolean byPassAuthenticationLog = false;
    protected String securityDomain = "nuxeo-ecm-web";

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean sendAuthenticationEvent(UserIdentificationInfo userInfo, String eventId, String comment) {
        LoginContext loginContext = null;
        try {
            try {
                loginContext = Framework.login();
            }
            catch (LoginException e) {
                log.error((Object)("Unable to log in in order to log Login event" + e.getMessage()));
                boolean bl = false;
                if (loginContext != null) {
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException e2) {
                        log.error((Object)("Unable to logout: " + e2.getMessage()));
                    }
                }
                return bl;
            }
            EventProducer evtProducer = null;
            try {
                evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            }
            catch (Exception e) {
                log.error((Object)("Unable to get Event producer: " + e.getMessage()));
                boolean e2 = false;
                if (loginContext != null) {
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException e3) {
                        log.error((Object)("Unable to logout: " + e3.getMessage()));
                    }
                }
                return e2;
            }
            SimplePrincipal principal = new SimplePrincipal(userInfo.getUserName());
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("AuthenticationPlugin", userInfo.getAuthPluginName());
            props.put("LoginPlugin", userInfo.getLoginPluginName());
            props.put("category", LOGIN_JMS_CATEGORY);
            props.put("comment", comment);
            UnboundEventContext ctx = new UnboundEventContext((Principal)principal, props);
            try {
                evtProducer.fireEvent(ctx.newEvent(eventId));
            }
            catch (ClientException e) {
                log.error((Object)"Unable to send authentication event", (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    log.error((Object)("Unable to logout: " + e.getMessage()));
                }
            }
        }
    }

    protected boolean logAuthenticationAttempt(UserIdentificationInfo userInfo, boolean success) {
        String comment;
        String eventId;
        if (this.byPassAuthenticationLog) {
            return true;
        }
        String userName = userInfo.getUserName();
        if (userName == null || userName.length() == 0) {
            userName = userInfo.getToken();
        }
        if (success) {
            eventId = "loginSuccess";
            comment = userName + " successfully logged in using " + userInfo.getAuthPluginName() + "Authentication";
        } else {
            eventId = "loginFailed";
            comment = userName + " failed to authenticate using " + userInfo.getAuthPluginName() + "Authentication";
        }
        return NuxeoAuthenticationFilter.sendAuthenticationEvent(userInfo, eventId, comment);
    }

    protected boolean logLogout(UserIdentificationInfo userInfo) {
        if (this.byPassAuthenticationLog) {
            return true;
        }
        String userName = userInfo.getUserName();
        if (userName == null || userName.length() == 0) {
            userName = userInfo.getToken();
        }
        String eventId = "logout";
        String comment = userName + " logged out";
        return NuxeoAuthenticationFilter.sendAuthenticationEvent(userInfo, eventId, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Principal doAuthenticate(CachableUserIdentificationInfo cachableUserIdent, HttpServletRequest httpRequest) {
        LoginContext loginContext;
        try {
            UserIdentificationInfoCallbackHandler handler = this.service.getCallbackHandler(cachableUserIdent.getUserInfo());
            loginContext = new LoginContext(this.securityDomain, (CallbackHandler)handler);
            Class<NuxeoAuthenticationFilter> clazz = NuxeoAuthenticationFilter.class;
            synchronized (NuxeoAuthenticationFilter.class) {
                loginContext.login();
                // ** MonitorExit[var5_7] (shouldn't be in output)
                Principal principal = (Principal)loginContext.getSubject().getPrincipals().toArray()[0];
                cachableUserIdent.setPrincipal(principal);
                cachableUserIdent.setAlreadyAuthenticated(true);
                cachableUserIdent.getUserInfo().setUserName(principal.getName());
                this.logAuthenticationAttempt(cachableUserIdent.getUserInfo(), true);
            }
        }
        catch (LoginException e) {
            this.logAuthenticationAttempt(cachableUserIdent.getUserInfo(), false);
            return null;
        }
        {
            httpRequest.setAttribute("org.nuxeo.ecm.login.context", (Object)loginContext);
            cachableUserIdent.setLoginContext(loginContext);
            boolean createSession = this.needSessionSaving(cachableUserIdent.getUserInfo());
            HttpSession session = httpRequest.getSession(createSession);
            if (session != null) {
                session.setAttribute("org.nuxeo.ecm.login.identity", (Object)cachableUserIdent);
            }
            this.service.onAuthenticatedSessionCreated((ServletRequest)httpRequest, session, cachableUserIdent);
            return cachableUserIdent.getPrincipal();
        }
    }

    private boolean switchUser(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String deputyLogin = (String)httpRequest.getAttribute("deputy");
        String targetPageAfterSwitch = (String)httpRequest.getAttribute("pageAfterSwitch");
        if (targetPageAfterSwitch == null) {
            targetPageAfterSwitch = DEFAULT_START_PAGE;
        }
        CachableUserIdentificationInfo cachableUserIdent = NuxeoAuthenticationFilter.retrieveIdentityFromCache(httpRequest);
        String originatingUser = cachableUserIdent.getUserInfo().getUserName();
        if (deputyLogin == null) {
            NuxeoPrincipal currentPrincipal = (NuxeoPrincipal)cachableUserIdent.getPrincipal();
            String previousUser = currentPrincipal.getOriginatingUser();
            if (previousUser == null) {
                return false;
            }
            deputyLogin = previousUser;
            originatingUser = null;
        }
        try {
            cachableUserIdent.getLoginContext().logout();
        }
        catch (LoginException e1) {
            log.error((Object)"Error while logout from main identity", (Throwable)e1);
        }
        HttpSession session = httpRequest.getSession(false);
        session = this.service.reinitSession(httpRequest);
        CachableUserIdentificationInfo newCachableUserIdent = new CachableUserIdentificationInfo(deputyLogin, deputyLogin);
        newCachableUserIdent.getUserInfo().setLoginPluginName("Trusting_LM");
        newCachableUserIdent.getUserInfo().setAuthPluginName(cachableUserIdent.getUserInfo().getAuthPluginName());
        Principal principal = this.doAuthenticate(newCachableUserIdent, httpRequest);
        if (principal != null) {
            NuxeoPrincipal nxUser = (NuxeoPrincipal)principal;
            if (originatingUser != null) {
                nxUser.setOriginatingUser(originatingUser);
            }
            this.propagateUserIdentificationInformation(cachableUserIdent);
        }
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
        String baseURL = this.service.getBaseURL(request);
        ((HttpServletResponse)response).sendRedirect(baseURL + targetPageAfterSwitch);
        return true;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean result;
        String tokenPage = NuxeoAuthenticationFilter.getRequestedPage(request);
        if (tokenPage.equals("swuser") && (result = this.switchUser(request, response, chain))) {
            return;
        }
        if (request instanceof NuxeoSecuredRequestWrapper) {
            log.debug((Object)"ReEntering Nuxeo Authentication Filter ... exiting directly");
            chain.doFilter(request, response);
            return;
        }
        if (this.service.canBypassRequest(request)) {
            log.debug((Object)"ReEntering Nuxeo Authentication Filter after URL rewrite ... exiting directly");
            chain.doFilter(request, response);
            return;
        }
        log.debug((Object)"Entering Nuxeo Authentication Filter");
        String targetPageURL = null;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Principal principal = httpRequest.getUserPrincipal();
        if (principal == null) {
            log.debug((Object)"Principal not found inside Request via getUserPrincipal");
            log.debug((Object)"Try getting authentication from cache");
            CachableUserIdentificationInfo cachableUserIdent = NuxeoAuthenticationFilter.retrieveIdentityFromCache(httpRequest);
            if (cachableUserIdent != null && cachableUserIdent.getUserInfo() != null && this.service.needResetLogin(request)) {
                HttpSession session = httpRequest.getSession(false);
                if (session != null) {
                    session.removeAttribute("org.nuxeo.ecm.login.identity");
                }
                this.propagateUserIdentificationInformation(cachableUserIdent);
                this.service.invalidateSession(request);
                cachableUserIdent = null;
            }
            if (cachableUserIdent != null && cachableUserIdent.getUserInfo() != null) {
                log.debug((Object)"userIdent found in cache, get the Principal from it without reloggin");
                principal = cachableUserIdent.getPrincipal();
                log.debug((Object)("Principal = " + principal.getName()));
                this.propagateUserIdentificationInformation(cachableUserIdent);
                String requestedPage = NuxeoAuthenticationFilter.getRequestedPage(httpRequest);
                if (requestedPage.equals("logout")) {
                    boolean redirected = this.handleLogout(request, response, cachableUserIdent);
                    cachableUserIdent = null;
                    principal = null;
                    if (redirected && httpRequest.getParameter("form_submitted_marker") == null) {
                        return;
                    }
                }
            }
            if (cachableUserIdent == null || cachableUserIdent.getUserInfo() == null) {
                String forceAuth;
                UserIdentificationInfo userIdent = this.handleRetrieveIdentity(httpRequest, httpResponse);
                if (userIdent != null && userIdent.getUserName().equals(this.getAnonymousId()) && (forceAuth = httpRequest.getParameter("forceAnonymousLogin")) != null && forceAuth.equals("true")) {
                    userIdent = null;
                }
                if (!(userIdent != null && userIdent.containsValidIdentity() || this.bypassAuth(httpRequest))) {
                    boolean res = this.handleLoginPrompt(httpRequest, httpResponse);
                    if (res) {
                        return;
                    }
                } else {
                    targetPageURL = NuxeoAuthenticationFilter.getSavedRequestedURL(httpRequest, httpResponse);
                }
                if (userIdent != null && userIdent.containsValidIdentity()) {
                    cachableUserIdent = new CachableUserIdentificationInfo(userIdent);
                    principal = this.doAuthenticate(cachableUserIdent, httpRequest);
                    if (principal != null) {
                        this.propagateUserIdentificationInformation(cachableUserIdent);
                        NuxeoAuthenticationPlugin plugin = this.getAuthenticator(cachableUserIdent);
                        if (plugin instanceof LoginResponseHandler && ((LoginResponseHandler)((Object)plugin)).onSuccess((HttpServletRequest)request, (HttpServletResponse)response)) {
                            return;
                        }
                    } else {
                        NuxeoAuthenticationPlugin plugin = this.getAuthenticator(cachableUserIdent);
                        if (plugin instanceof LoginResponseHandler) {
                            if (((LoginResponseHandler)((Object)plugin)).onError((HttpServletRequest)request, (HttpServletResponse)response)) {
                                return;
                            }
                        } else {
                            httpRequest.setAttribute("org.nuxeo.ecm.login.error", (Object)"authentication.failed");
                            boolean res = this.handleLoginPrompt(httpRequest, httpResponse);
                            if (res) {
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (principal != null) {
            if (targetPageURL != null) {
                String baseURL = this.service.getBaseURL(request);
                if (XMLHTTP_REQUEST_TYPE.equalsIgnoreCase(httpRequest.getHeader("X-Requested-With"))) {
                    return;
                }
                httpResponse.sendRedirect(baseURL + targetPageURL);
                return;
            }
            chain.doFilter((ServletRequest)new NuxeoSecuredRequestWrapper(httpRequest, principal), response);
        } else {
            chain.doFilter(request, response);
        }
        log.debug((Object)"Exit Nuxeo Authentication filter");
    }

    public NuxeoAuthenticationPlugin getAuthenticator(CachableUserIdentificationInfo ci) {
        String key = ci.getUserInfo().getAuthPluginName();
        if (key != null) {
            NuxeoAuthenticationPlugin authPlugin = this.service.getPlugin(key);
            return authPlugin;
        }
        return null;
    }

    protected static CachableUserIdentificationInfo retrieveIdentityFromCache(HttpServletRequest httpRequest) {
        CachableUserIdentificationInfo cachableUserInfo;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (cachableUserInfo = (CachableUserIdentificationInfo)session.getAttribute("org.nuxeo.ecm.login.identity")) != null) {
            return cachableUserInfo;
        }
        return null;
    }

    private String getAnonymousId() throws ServletException {
        if (anonymous == null) {
            try {
                UserManager um = (UserManager)Framework.getService(UserManager.class);
                anonymous = um.getAnonymousUserId();
            }
            catch (Exception e) {
                log.error((Object)"Can't find anonymous User id", (Throwable)e);
                anonymous = "";
                throw new ServletException("Can't find anonymous user id");
            }
        }
        return anonymous;
    }

    public void init(FilterConfig config) throws ServletException {
        String val = config.getInitParameter("byPassAuthenticationLog");
        if (val != null && Boolean.parseBoolean(val)) {
            this.byPassAuthenticationLog = true;
        }
        if ((val = config.getInitParameter("securityDomain")) != null) {
            this.securityDomain = val;
        }
        this.service = (PluggableAuthenticationService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService"));
        if (this.service == null) {
            log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            throw new ServletException("Can't initialize Nuxeo Pluggable Authentication Service");
        }
    }

    public boolean saveRequestedURLBeforeRedirect(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String requestPage;
        HttpSession session = httpResponse.isCommitted() ? httpRequest.getSession(false) : httpRequest.getSession(true);
        if (session == null) {
            return false;
        }
        boolean requestPageInParams = false;
        if (httpRequest.getParameter("requestedUrl") != null) {
            requestPageInParams = true;
            requestPage = httpRequest.getParameter("requestedUrl");
        } else {
            requestPage = NuxeoAuthenticationFilter.getRequestedUrl(httpRequest);
        }
        if (requestPage == null) {
            return false;
        }
        if (requestPage.startsWith(DEFAULT_START_PAGE)) {
            return true;
        }
        if (this.isStartPageValid(requestPage)) {
            if (!requestPageInParams) {
                session.setAttribute("Nuxeo5_Start_Page", (Object)requestPage);
            }
            return true;
        }
        return false;
    }

    public static String getRequestedUrl(HttpServletRequest httpRequest) {
        String completeURI = httpRequest.getRequestURI();
        String qs = httpRequest.getQueryString();
        String context = httpRequest.getContextPath() + '/';
        String requestPage = completeURI.substring(context.length());
        if (qs != null && qs.length() > 0) {
            if (qs.contains("conversationId")) {
                qs = qs.replace("conversationId", "old_conversationId");
            }
            requestPage = requestPage + '?' + qs;
        }
        return requestPage;
    }

    protected static String getSavedRequestedURL(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String requestedUrl;
        String requestedPage = null;
        if (httpRequest.getParameter("Nuxeo5_Start_Page") == null) {
            HttpSession session = httpRequest.getSession(false);
            if (session != null && (requestedPage = (String)session.getAttribute("Nuxeo5_Start_Page")) != null) {
                session.removeAttribute("Nuxeo5_Start_Page");
            }
        } else {
            requestedPage = httpRequest.getParameter("Nuxeo5_Start_Page");
        }
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"sso.initial.url.request".equals(cookie.getName())) continue;
                requestedPage = cookie.getValue();
                cookie.setMaxAge(0);
            }
        }
        if ((requestedUrl = httpRequest.getParameter("requestedUrl")) != null && !"".equals(requestedUrl)) {
            try {
                return URLDecoder.decode(requestedUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Unable to get the requestedUrl parameter" + e));
            }
        }
        return requestedPage;
    }

    protected boolean isStartPageValid(String startPage) {
        if (startPage == null) {
            return false;
        }
        for (String prefix : this.service.getStartURLPatterns()) {
            if (!startPage.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean handleLogout(ServletRequest request, ServletResponse response, CachableUserIdentificationInfo cachedUserInfo) throws ServletException {
        String requestedUrl;
        this.logLogout(cachedUserInfo.getUserInfo());
        this.service.invalidateSession(request);
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String securityError = request.getParameter("securityError");
        if (securityError != null) {
            parameters.put("securityError", securityError);
        }
        if (cachedUserInfo.getPrincipal().getName().equals(this.getAnonymousId())) {
            parameters.put("forceAnonymousLogin", "true");
        }
        if ((requestedUrl = request.getParameter("requestedUrl")) != null) {
            parameters.put("requestedUrl", requestedUrl);
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Cookie cookie = new Cookie("JSESSIONID", null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        httpResponse.addCookie(cookie);
        String pluginName = cachedUserInfo.getUserInfo().getAuthPluginName();
        NuxeoAuthenticationPlugin authPlugin = this.service.getPlugin(pluginName);
        NuxeoAuthenticationPluginLogoutExtension logoutPlugin = null;
        if (authPlugin instanceof NuxeoAuthenticationPluginLogoutExtension) {
            logoutPlugin = (NuxeoAuthenticationPluginLogoutExtension)((Object)authPlugin);
        }
        boolean redirected = false;
        if (logoutPlugin != null) {
            redirected = logoutPlugin.handleLogout((HttpServletRequest)request, (HttpServletResponse)response);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!redirected && !XMLHTTP_REQUEST_TYPE.equalsIgnoreCase(httpRequest.getHeader("X-Requested-With"))) {
            String baseURL = this.service.getBaseURL(request);
            try {
                String url = baseURL + DEFAULT_START_PAGE;
                url = URIUtils.addParametersToURIQuery((String)url, parameters);
                ((HttpServletResponse)response).sendRedirect(url);
                redirected = true;
            }
            catch (IOException e) {
                log.error((Object)("Unable to redirect to default start page after logout : " + e.getMessage()));
            }
        }
        try {
            cachedUserInfo.getLoginContext().logout();
        }
        catch (LoginException e) {
            log.error((Object)("Unable to logout " + e.getMessage()));
        }
        return redirected;
    }

    protected void propagateUserIdentificationInformation(CachableUserIdentificationInfo cachableUserIdent) {
        this.service.propagateUserIdentificationInformation(cachableUserIdent);
    }

    protected void initUnAuthenticatedURLPrefix() {
        this.unAuthenticatedURLPrefix = new ArrayList<String>();
        for (String pluginName : this.service.getAuthChain()) {
            NuxeoAuthenticationPlugin plugin = this.service.getPlugin(pluginName);
            List<String> prefix = plugin.getUnAuthenticatedURLPrefix();
            if (prefix == null || prefix.isEmpty()) continue;
            this.unAuthenticatedURLPrefix.addAll(prefix);
        }
    }

    protected boolean bypassAuth(HttpServletRequest httpRequest) {
        if (this.unAuthenticatedURLPrefix == null) {
            this.initUnAuthenticatedURLPrefix();
        }
        String requestPage = NuxeoAuthenticationFilter.getRequestedPage(httpRequest);
        for (String prefix : this.unAuthenticatedURLPrefix) {
            if (!requestPage.startsWith(prefix)) continue;
            return true;
        }
        List<OpenUrlDescriptor> openUrls = this.service.getOpenUrls();
        for (OpenUrlDescriptor openUrl : openUrls) {
            if (!openUrl.allowByPassAuth(httpRequest)) continue;
            return true;
        }
        return false;
    }

    public static String getRequestedPage(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            return NuxeoAuthenticationFilter.getRequestedPage(httpRequest);
        }
        return null;
    }

    protected static String getRequestedPage(HttpServletRequest httpRequest) {
        String requestURI = httpRequest.getRequestURI();
        String context = httpRequest.getContextPath() + '/';
        return requestURI.substring(context.length());
    }

    protected boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String baseURL = this.service.getBaseURL((ServletRequest)httpRequest);
        for (String pluginName : this.service.getAuthChain(httpRequest)) {
            NuxeoAuthenticationPlugin plugin = this.service.getPlugin(pluginName);
            AuthenticationPluginDescriptor descriptor = this.service.getDescriptor(pluginName);
            if (!plugin.needLoginPrompt(httpRequest).booleanValue()) continue;
            if (descriptor.getNeedStartingURLSaving()) {
                this.saveRequestedURLBeforeRedirect(httpRequest, httpResponse);
            }
            return plugin.handleLoginPrompt(httpRequest, httpResponse, baseURL);
        }
        log.error((Object)"No auth plugin can be found to do the Login Prompt");
        return false;
    }

    protected UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        UserIdentificationInfo userIdent = null;
        for (String pluginName : this.service.getAuthChain(httpRequest)) {
            NuxeoAuthenticationPlugin plugin = this.service.getPlugin(pluginName);
            if (plugin != null) {
                log.debug((Object)("Trying to retrieve userIndetification using plugin " + pluginName));
                userIdent = plugin.handleRetrieveIdentity(httpRequest, httpResponse);
                if (userIdent == null || !userIdent.containsValidIdentity()) continue;
                userIdent.setAuthPluginName(pluginName);
                String loginModulePlugin = this.service.getDescriptor(pluginName).getLoginModulePlugin();
                userIdent.setLoginPluginName(loginModulePlugin);
                Map<String, String> parameters = this.service.getDescriptor(pluginName).getParameters();
                userIdent.setLoginParameters(parameters);
                break;
            }
            log.error((Object)("Auth plugin " + pluginName + " can not be retrieved from service"));
        }
        if (userIdent == null || !userIdent.containsValidIdentity()) {
            CachableUserIdentificationInfo savedUserInfo;
            log.debug((Object)"user/password not found in request, try into identity cache");
            HttpSession session = httpRequest.getSession(false);
            if (session == null && httpRequest.isRequestedSessionIdValid()) {
                session = httpRequest.getSession(true);
            }
            if (session != null && (savedUserInfo = NuxeoAuthenticationFilter.retrieveIdentityFromCache(httpRequest)) != null) {
                log.debug((Object)("Found User identity in cache :" + savedUserInfo.getUserInfo().getUserName() + '/' + savedUserInfo.getUserInfo().getPassword()));
                userIdent = new UserIdentificationInfo(savedUserInfo.getUserInfo());
                savedUserInfo.setPrincipal(null);
            }
        } else {
            log.debug((Object)"User/Password found as parameter of the request");
        }
        return userIdent;
    }

    protected boolean needSessionSaving(UserIdentificationInfo userInfo) {
        String pluginName = userInfo.getAuthPluginName();
        AuthenticationPluginDescriptor desc = this.service.getDescriptor(pluginName);
        if (desc.getStateful()) {
            return true;
        }
        return desc.getNeedStartingURLSaving();
    }
}

