/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webengine.fm.extensions;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.fm.extensions.BlockWriter;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.negotiation.NegotiationException;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.webengine.negotiation.WebNegotiator;

public class ThemeDirective
implements TemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(ThemeDirective.class);
    private final Map<URL, String> cachedThemes = new HashMap<URL, String>();
    private final Map<URL, Long> lastRefreshedMap = new HashMap<URL, Long>();

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        URL themeUrl;
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive doesn't allow loop variables.");
        }
        if (body == null) {
            throw new TemplateModelException("Expecting a body");
        }
        WebContext ctx = WebEngine.getActiveContext();
        if (ctx == null) {
            throw new IllegalStateException("Not In a Web Context");
        }
        String strategy = null;
        SimpleScalar strategyModel = (SimpleScalar)params.get("strategy");
        if (strategyModel != null) {
            strategy = strategyModel.getAsString();
        }
        if ((themeUrl = ThemeDirective.getThemeUrlAndSetupRequest(ctx, strategy)) == null) {
            return;
        }
        String rendered = "";
        try {
            rendered = this.renderTheme(themeUrl);
        }
        catch (ThemeException e) {
            log.error((Object)"Theme rendering failed", (Throwable)e);
            return;
        }
        BlockWriter writer = (BlockWriter)env.getOut();
        writer.setSuppressOutput(true);
        body.render((Writer)writer);
        writer.setSuppressOutput(false);
        BufferedReader reader = new BufferedReader(new StringReader(rendered));
        Template tpl = new Template(themeUrl.toString(), (Reader)reader, env.getConfiguration(), env.getTemplate().getEncoding());
        env.include(tpl);
        reader.close();
    }

    public String renderTheme(URL themeUrl) throws ThemeException {
        if (!this.needsToBeRefreshed(themeUrl) && this.cachedThemes.containsKey(themeUrl)) {
            return this.cachedThemes.get(themeUrl);
        }
        String result = ThemeManager.renderElement((URL)themeUrl);
        if (result != null) {
            this.cachedThemes.put(themeUrl, result);
            this.lastRefreshedMap.put(themeUrl, new Date().getTime());
        }
        return result;
    }

    protected boolean needsToBeRefreshed(URL themeUrl) {
        if (themeUrl == null) {
            return false;
        }
        if (themeUrl.getProtocol().equals("nxtheme")) {
            Long lastRefreshed = this.lastRefreshedMap.get(themeUrl);
            if (lastRefreshed == null) {
                lastRefreshed = 0L;
            }
            try {
                if (themeUrl.openConnection().getLastModified() >= lastRefreshed) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private static URL getThemeUrlAndSetupRequest(WebContext context, String strategy) throws IOException {
        HttpServletRequest request = context.getRequest();
        URL themeUrl = (URL)request.getAttribute("org.nuxeo.theme.url");
        if (themeUrl != null) {
            return themeUrl;
        }
        ApplicationType application = (ApplicationType)Manager.getTypeRegistry().lookup(TypeFamily.APPLICATION, new String[]{context.getModulePath(), context.getModule().getName()});
        if (application == null) {
            log.error((Object)ThemeDirective.getErrorMessage("Application not set for: ", context));
            return null;
        }
        NegotiationDef negotiation = application.getNegotiation();
        if (negotiation == null) {
            log.error((Object)ThemeDirective.getErrorMessage("Negotiation not set for: ", context));
            return null;
        }
        request.setAttribute("org.nuxeo.theme.default.theme", (Object)negotiation.getDefaultTheme());
        request.setAttribute("org.nuxeo.theme.default.engine", (Object)negotiation.getDefaultEngine());
        request.setAttribute("org.nuxeo.theme.default.perspective", (Object)negotiation.getDefaultPerspective());
        if (strategy == null) {
            strategy = negotiation.getStrategy();
        }
        if (strategy == null) {
            log.error((Object)ThemeDirective.getErrorMessage("Negotiation strategy not set for: ", context));
            return null;
        }
        try {
            String spec = new WebNegotiator(strategy, context).getSpec();
            themeUrl = new URL(spec);
        }
        catch (NegotiationException e) {
            log.error((Object)ThemeDirective.getErrorMessage("Could not get negotiation information for: ", context));
            return null;
        }
        request.setAttribute("org.nuxeo.theme.url", (Object)themeUrl);
        return themeUrl;
    }

    private static String getErrorMessage(String message, WebContext context) {
        return context.getModulePath() + "," + context.getModule().getName();
    }
}

