/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webengine.fm.extensions;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.html.ui.ThemeStyles;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.webengine.fm.extensions.Utils;

public class NXThemesThemeStylesDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive doesn't allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("Didn't expect a body");
        }
        Writer writer = env.getOut();
        WebContext context = WebEngine.getActiveContext();
        HttpServletRequest request = context.getRequest();
        URL themeUrl = (URL)request.getAttribute("org.nuxeo.theme.url");
        Boolean cache = false;
        if (params.containsKey("cache")) {
            cache = Boolean.parseBoolean(params.get("cache").toString());
        }
        Boolean inline = false;
        if (params.containsKey("inline")) {
            inline = Boolean.parseBoolean(params.get("inline").toString());
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("themeName", ThemeManager.getThemeNameByUrl((URL)themeUrl));
        attributes.put("path", context.getModulePath());
        attributes.put("basepath", context.getBasePath());
        Boolean virtualHosting = Utils.isWebEngineVirtualHosting(request);
        writer.write(ThemeStyles.render(attributes, (boolean)cache, (boolean)inline, (boolean)virtualHosting));
    }
}

