/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.AssertionFailure;

public final class GetGeneratedKeysHelper {
    private static final Integer RETURN_GENERATED_KEYS;
    private static final Method PREPARE_STATEMENT_METHOD;
    private static final Method GET_GENERATED_KEYS_METHOD;

    static {
        try {
            int returnGeneratedKeysEnumValue = Statement.class.getDeclaredField("RETURN_GENERATED_KEYS").getInt(PreparedStatement.class);
            RETURN_GENERATED_KEYS = new Integer(returnGeneratedKeysEnumValue);
            PREPARE_STATEMENT_METHOD = Connection.class.getMethod("prepareStatement", String.class, Integer.TYPE);
            GET_GENERATED_KEYS_METHOD = Statement.class.getDeclaredMethod("getGeneratedKeys", null);
        }
        catch (Exception e) {
            throw new AssertionFailure("could not initialize getGeneratedKeys() support", e);
        }
    }

    private GetGeneratedKeysHelper() {
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        Object[] args = new Object[]{sql, RETURN_GENERATED_KEYS};
        try {
            return (PreparedStatement)PREPARE_STATEMENT_METHOD.invoke((Object)conn, args);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof SQLException) {
                throw (SQLException)ite.getTargetException();
            }
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException preparing statement capable of returning generated keys (JDBC3)", ite);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailure("IllegalAccessException preparing statement capable of returning generated keys (JDBC3)", iae);
        }
    }

    public static ResultSet getGeneratedKey(PreparedStatement ps) throws SQLException {
        try {
            return (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)ps, null);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof SQLException) {
                throw (SQLException)ite.getTargetException();
            }
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException extracting generated keys (JDBC3)", ite);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailure("IllegalAccessException extracting generated keys (JDBC3)", iae);
        }
    }
}

