/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.HibernateException;

public class Cloneable {
    private static final Object[] READER_METHOD_ARGS = new Object[0];

    public Object shallowCopy() {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Cloneable.this.copyListeners();
            }
        });
    }

    public void validate() throws HibernateException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cloneable.this.checkListeners();
                return null;
            }
        });
    }

    private Object copyListeners() {
        Object copy = null;
        BeanInfo beanInfo = null;
        try {
            try {
                beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
                this.internalCheckListeners(beanInfo);
                copy = this.getClass().newInstance();
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                int i = 0;
                int max = pds.length;
                while (i < max) {
                    try {
                        pds[i].getWriteMethod().invoke(copy, pds[i].getReadMethod().invoke((Object)this, READER_METHOD_ARGS));
                    }
                    catch (Throwable t) {
                        throw new HibernateException("Unable copy copy listener [" + pds[i].getName() + "]");
                    }
                    ++i;
                }
            }
            catch (Exception t) {
                throw new HibernateException("Unable to copy listeners", t);
            }
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(this.getClass());
            }
        }
        return copy;
    }

    private void checkListeners() {
        BeanInfo beanInfo = null;
        try {
            try {
                beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
                this.internalCheckListeners(beanInfo);
            }
            catch (IntrospectionException t) {
                throw new HibernateException("Unable to validate listener config", t);
            }
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(this.getClass());
            }
        }
    }

    private void internalCheckListeners(BeanInfo beanInfo) {
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        try {
            int i = 0;
            int max = pds.length;
            while (i < max) {
                Object listener = pds[i].getReadMethod().invoke((Object)this, READER_METHOD_ARGS);
                if (listener == null) {
                    throw new HibernateException("Listener [" + pds[i].getName() + "] was null");
                }
                if (listener.getClass().isArray()) {
                    Object[] listenerArray = (Object[])listener;
                    int length = listenerArray.length;
                    int index = 0;
                    while (index < length) {
                        if (listenerArray[index] == null) {
                            throw new HibernateException("Listener in [" + pds[i].getName() + "] was null");
                        }
                        ++index;
                    }
                }
                ++i;
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to validate listener config");
        }
    }
}

