/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AdaptedImmutableType;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.DbTimestampType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IdentifierBagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.OrderedMapType;
import org.hibernate.type.OrderedSetType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ReflectHelper;

public final class TypeFactory {
    private static final Map BASIC_TYPES;

    static {
        HashMap<String, Type> basics = new HashMap<String, Type>();
        basics.put(Boolean.TYPE.getName(), Hibernate.BOOLEAN);
        basics.put(Long.TYPE.getName(), Hibernate.LONG);
        basics.put(Short.TYPE.getName(), Hibernate.SHORT);
        basics.put(Integer.TYPE.getName(), Hibernate.INTEGER);
        basics.put(Byte.TYPE.getName(), Hibernate.BYTE);
        basics.put(Float.TYPE.getName(), Hibernate.FLOAT);
        basics.put(Double.TYPE.getName(), Hibernate.DOUBLE);
        basics.put(Character.TYPE.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.CHARACTER.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.INTEGER.getName(), Hibernate.INTEGER);
        basics.put(Hibernate.STRING.getName(), Hibernate.STRING);
        basics.put(Hibernate.DATE.getName(), Hibernate.DATE);
        basics.put(Hibernate.TIME.getName(), Hibernate.TIME);
        basics.put(Hibernate.TIMESTAMP.getName(), Hibernate.TIMESTAMP);
        basics.put("dbtimestamp", new DbTimestampType());
        basics.put(Hibernate.LOCALE.getName(), Hibernate.LOCALE);
        basics.put(Hibernate.CALENDAR.getName(), Hibernate.CALENDAR);
        basics.put(Hibernate.CALENDAR_DATE.getName(), Hibernate.CALENDAR_DATE);
        basics.put(Hibernate.CURRENCY.getName(), Hibernate.CURRENCY);
        basics.put(Hibernate.TIMEZONE.getName(), Hibernate.TIMEZONE);
        basics.put(Hibernate.CLASS.getName(), Hibernate.CLASS);
        basics.put(Hibernate.TRUE_FALSE.getName(), Hibernate.TRUE_FALSE);
        basics.put(Hibernate.YES_NO.getName(), Hibernate.YES_NO);
        basics.put(Hibernate.BINARY.getName(), Hibernate.BINARY);
        basics.put(Hibernate.TEXT.getName(), Hibernate.TEXT);
        basics.put(Hibernate.BLOB.getName(), Hibernate.BLOB);
        basics.put(Hibernate.CLOB.getName(), Hibernate.CLOB);
        basics.put(Hibernate.BIG_DECIMAL.getName(), Hibernate.BIG_DECIMAL);
        basics.put(Hibernate.BIG_INTEGER.getName(), Hibernate.BIG_INTEGER);
        basics.put(Hibernate.SERIALIZABLE.getName(), Hibernate.SERIALIZABLE);
        basics.put(Hibernate.OBJECT.getName(), Hibernate.OBJECT);
        basics.put(Boolean.class.getName(), Hibernate.BOOLEAN);
        basics.put(Long.class.getName(), Hibernate.LONG);
        basics.put(Short.class.getName(), Hibernate.SHORT);
        basics.put(Integer.class.getName(), Hibernate.INTEGER);
        basics.put(Byte.class.getName(), Hibernate.BYTE);
        basics.put(Float.class.getName(), Hibernate.FLOAT);
        basics.put(Double.class.getName(), Hibernate.DOUBLE);
        basics.put(Character.class.getName(), Hibernate.CHARACTER);
        basics.put(String.class.getName(), Hibernate.STRING);
        basics.put(java.util.Date.class.getName(), Hibernate.TIMESTAMP);
        basics.put(Time.class.getName(), Hibernate.TIME);
        basics.put(Timestamp.class.getName(), Hibernate.TIMESTAMP);
        basics.put(Date.class.getName(), Hibernate.DATE);
        basics.put(BigDecimal.class.getName(), Hibernate.BIG_DECIMAL);
        basics.put(BigInteger.class.getName(), Hibernate.BIG_INTEGER);
        basics.put(Locale.class.getName(), Hibernate.LOCALE);
        basics.put(Calendar.class.getName(), Hibernate.CALENDAR);
        basics.put(GregorianCalendar.class.getName(), Hibernate.CALENDAR);
        if (CurrencyType.CURRENCY_CLASS != null) {
            basics.put(CurrencyType.CURRENCY_CLASS.getName(), Hibernate.CURRENCY);
        }
        basics.put(TimeZone.class.getName(), Hibernate.TIMEZONE);
        basics.put(Object.class.getName(), Hibernate.OBJECT);
        basics.put(Class.class.getName(), Hibernate.CLASS);
        basics.put(byte[].class.getName(), Hibernate.BINARY);
        basics.put("byte[]", Hibernate.BINARY);
        basics.put(Byte[].class.getName(), Hibernate.WRAPPER_BINARY);
        basics.put("Byte[]", Hibernate.WRAPPER_BINARY);
        basics.put(char[].class.getName(), Hibernate.CHAR_ARRAY);
        basics.put("char[]", Hibernate.CHAR_ARRAY);
        basics.put(Character[].class.getName(), Hibernate.CHARACTER_ARRAY);
        basics.put("Character[]", Hibernate.CHARACTER_ARRAY);
        basics.put(Blob.class.getName(), Hibernate.BLOB);
        basics.put(Clob.class.getName(), Hibernate.CLOB);
        basics.put(Serializable.class.getName(), Hibernate.SERIALIZABLE);
        AdaptedImmutableType type = new AdaptedImmutableType(Hibernate.DATE);
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(Hibernate.TIME);
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(Hibernate.TIMESTAMP);
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(new DbTimestampType());
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(Hibernate.CALENDAR);
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(Hibernate.CALENDAR_DATE);
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(Hibernate.SERIALIZABLE);
        basics.put(type.getName(), type);
        type = new AdaptedImmutableType(Hibernate.BINARY);
        basics.put(type.getName(), type);
        BASIC_TYPES = Collections.unmodifiableMap(basics);
    }

    private TypeFactory() {
        throw new UnsupportedOperationException();
    }

    public static EntityType oneToOne(String persistentClass, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, boolean isEmbeddedInXML, String entityName, String propertyName) {
        return new OneToOneType(persistentClass, foreignKeyType, uniqueKeyPropertyName, lazy, unwrapProxy, isEmbeddedInXML, entityName, propertyName);
    }

    public static EntityType manyToOne(String persistentClass) {
        return new ManyToOneType(persistentClass);
    }

    public static EntityType manyToOne(String persistentClass, boolean lazy) {
        return new ManyToOneType(persistentClass, lazy);
    }

    public static EntityType manyToOne(String persistentClass, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, boolean isEmbeddedInXML, boolean ignoreNotFound) {
        return new ManyToOneType(persistentClass, uniqueKeyPropertyName, lazy, unwrapProxy, isEmbeddedInXML, ignoreNotFound);
    }

    public static Type basic(String name) {
        return (Type)BASIC_TYPES.get(name);
    }

    public static Type heuristicType(String typeName) throws MappingException {
        return TypeFactory.heuristicType(typeName, null);
    }

    public static Type heuristicType(String typeName, Properties parameters) throws MappingException {
        Type type = TypeFactory.basic(typeName);
        if (type == null) {
            Class typeClass;
            try {
                typeClass = ReflectHelper.classForName(typeName);
            }
            catch (ClassNotFoundException cnfe) {
                typeClass = null;
            }
            if (typeClass != null) {
                if (Type.class.isAssignableFrom(typeClass)) {
                    try {
                        type = (Type)typeClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new MappingException("Could not instantiate Type: " + typeClass.getName(), e);
                    }
                    TypeFactory.injectParameters(type, parameters);
                } else if (CompositeUserType.class.isAssignableFrom(typeClass)) {
                    type = new CompositeCustomType(typeClass, parameters);
                } else if (UserType.class.isAssignableFrom(typeClass)) {
                    type = new CustomType(typeClass, parameters);
                } else if (Lifecycle.class.isAssignableFrom(typeClass)) {
                    type = Hibernate.entity(typeClass);
                } else if (Serializable.class.isAssignableFrom(typeClass)) {
                    type = Hibernate.serializable(typeClass);
                }
            }
        }
        return type;
    }

    public static CollectionType customCollection(String typeName, String role, String propertyRef, boolean embedded) {
        return TypeFactory.customCollection(typeName, null, role, propertyRef, embedded);
    }

    public static CollectionType customCollection(String typeName, Properties typeParameters, String role, String propertyRef, boolean embedded) {
        Class typeClass;
        try {
            typeClass = ReflectHelper.classForName(typeName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("user collection type class not found: " + typeName, cnfe);
        }
        CustomCollectionType result = new CustomCollectionType(typeClass, role, propertyRef, embedded);
        if (typeParameters != null) {
            TypeFactory.injectParameters(result.getUserType(), typeParameters);
        }
        return result;
    }

    public static CollectionType array(String role, String propertyRef, boolean embedded, Class elementClass) {
        return new ArrayType(role, propertyRef, elementClass, embedded);
    }

    public static CollectionType list(String role, String propertyRef, boolean embedded) {
        return new ListType(role, propertyRef, embedded);
    }

    public static CollectionType bag(String role, String propertyRef, boolean embedded) {
        return new BagType(role, propertyRef, embedded);
    }

    public static CollectionType idbag(String role, String propertyRef, boolean embedded) {
        return new IdentifierBagType(role, propertyRef, embedded);
    }

    public static CollectionType map(String role, String propertyRef, boolean embedded) {
        return new MapType(role, propertyRef, embedded);
    }

    public static CollectionType orderedMap(String role, String propertyRef, boolean embedded) {
        return new OrderedMapType(role, propertyRef, embedded);
    }

    public static CollectionType set(String role, String propertyRef, boolean embedded) {
        return new SetType(role, propertyRef, embedded);
    }

    public static CollectionType orderedSet(String role, String propertyRef, boolean embedded) {
        return new OrderedSetType(role, propertyRef, embedded);
    }

    public static CollectionType sortedMap(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedMapType(role, propertyRef, comparator, embedded);
    }

    public static CollectionType sortedSet(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedSetType(role, propertyRef, comparator, embedded);
    }

    public static void injectParameters(Object type, Properties parameters) {
        if (type instanceof ParameterizedType) {
            ((ParameterizedType)type).setParameterValues(parameters);
        } else if (parameters != null && !parameters.isEmpty()) {
            throw new MappingException("type is not parameterized: " + type.getClass().getName());
        }
    }

    public static void deepCopy(Object[] values, Type[] types, boolean[] copy, Object[] target, SessionImplementor session) {
        int i = 0;
        while (i < types.length) {
            if (copy[i]) {
                target[i] = values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || values[i] == BackrefPropertyAccessor.UNKNOWN ? values[i] : types[i].deepCopy(values[i], session.getEntityMode(), session.getFactory());
            }
            ++i;
        }
    }

    public static void beforeAssemble(Serializable[] row, Type[] types, SessionImplementor session) {
        int i = 0;
        while (i < types.length) {
            if (row[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && row[i] != BackrefPropertyAccessor.UNKNOWN) {
                types[i].beforeAssemble(row[i], session);
            }
            ++i;
        }
    }

    public static Object[] assemble(Serializable[] row, Type[] types, SessionImplementor session, Object owner) {
        Object[] assembled = new Object[row.length];
        int i = 0;
        while (i < types.length) {
            assembled[i] = row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == BackrefPropertyAccessor.UNKNOWN ? row[i] : types[i].assemble(row[i], session, owner);
            ++i;
        }
        return assembled;
    }

    public static Serializable[] disassemble(Object[] row, Type[] types, boolean[] nonCacheable, SessionImplementor session, Object owner) {
        Serializable[] disassembled = new Serializable[row.length];
        int i = 0;
        while (i < row.length) {
            disassembled[i] = nonCacheable != null && nonCacheable[i] ? LazyPropertyInitializer.UNFETCHED_PROPERTY : (row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == BackrefPropertyAccessor.UNKNOWN ? (Serializable)row[i] : types[i].disassemble(row[i], session, owner));
            ++i;
        }
        return disassembled;
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache) {
        Object[] copied = new Object[original.length];
        int i = 0;
        while (i < types.length) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == BackrefPropertyAccessor.UNKNOWN ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache);
            ++i;
        }
        return copied;
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        int i = 0;
        while (i < types.length) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == BackrefPropertyAccessor.UNKNOWN ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache, foreignKeyDirection);
            ++i;
        }
        return copied;
    }

    public static Object[] replaceAssociations(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        int i = 0;
        while (i < types.length) {
            if (original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == BackrefPropertyAccessor.UNKNOWN) {
                copied[i] = target[i];
            } else if (types[i].isComponentType()) {
                AbstractComponentType componentType = (AbstractComponentType)types[i];
                Type[] subtypes = componentType.getSubtypes();
                Object[] origComponentValues = original[i] == null ? new Object[subtypes.length] : componentType.getPropertyValues(original[i], session);
                Object[] targetComponentValues = componentType.getPropertyValues(target[i], session);
                TypeFactory.replaceAssociations(origComponentValues, targetComponentValues, subtypes, session, null, copyCache, foreignKeyDirection);
                copied[i] = target[i];
            } else {
                copied[i] = !types[i].isAssociationType() ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache, foreignKeyDirection);
            }
            ++i;
        }
        return copied;
    }

    public static int[] findDirty(StandardProperty[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, boolean anyUninitializedProperties, SessionImplementor session) {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        int i = 0;
        while (i < span) {
            boolean dirty;
            boolean bl = dirty = currentState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && properties[i].isDirtyCheckable(anyUninitializedProperties) && properties[i].getType().isDirty(previousState[i], currentState[i], includeColumns[i], session);
            if (dirty) {
                if (results == null) {
                    results = new int[span];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    public static int[] findModified(StandardProperty[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, boolean anyUninitializedProperties, SessionImplementor session) {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        int i = 0;
        while (i < span) {
            boolean modified;
            boolean bl = modified = currentState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && properties[i].isDirtyCheckable(anyUninitializedProperties) && properties[i].getType().isModified(previousState[i], currentState[i], includeColumns[i], session);
            if (modified) {
                if (results == null) {
                    results = new int[span];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }
}

