/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentMap;
import org.hibernate.collection.PersistentMapElementHolder;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class MapType
extends CollectionType {
    public MapType(String role, String propertyRef, boolean isEmbeddedInXML) {
        super(role, propertyRef, isEmbeddedInXML);
    }

    public PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister, Serializable key) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentMapElementHolder(session, persister, key);
        }
        return new PersistentMap(session);
    }

    public Class getReturnedClass() {
        return Map.class;
    }

    public Iterator getElementsIterator(Object collection) {
        return ((Map)collection).values().iterator();
    }

    public PersistentCollection wrap(SessionImplementor session, Object collection) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentMapElementHolder(session, (Element)collection);
        }
        return new PersistentMap(session, (Map)collection);
    }

    public Object instantiate(int anticipatedSize) {
        return anticipatedSize <= 0 ? new HashMap() : new HashMap(anticipatedSize + (int)((float)anticipatedSize * 0.75f), 0.75f);
    }

    public Object replaceElements(Object original, Object target, Object owner, Map copyCache, SessionImplementor session) throws HibernateException {
        CollectionPersister cp = session.getFactory().getCollectionPersister(this.getRole());
        Map result = (Map)target;
        result.clear();
        for (Map.Entry me : ((Map)original).entrySet()) {
            Object key = cp.getIndexType().replace(me.getKey(), null, session, owner, copyCache);
            Object value = cp.getElementType().replace(me.getValue(), null, session, owner, copyCache);
            result.put(key, value);
        }
        return result;
    }

    public Object indexOf(Object collection, Object element) {
        for (Map.Entry me : ((Map)collection).entrySet()) {
            if (me.getValue() != element) continue;
            return me.getKey();
        }
        return null;
    }
}

