/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.CompositeUserType;

public class CompositeCustomType
extends AbstractType
implements AbstractComponentType {
    private final CompositeUserType userType;
    private final String name;

    public CompositeCustomType(Class userTypeClass, Properties parameters) throws MappingException {
        this.name = userTypeClass.getName();
        if (!CompositeUserType.class.isAssignableFrom(userTypeClass)) {
            throw new MappingException("Custom type does not implement CompositeUserType: " + userTypeClass.getName());
        }
        try {
            this.userType = (CompositeUserType)userTypeClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new MappingException("Cannot instantiate custom type: " + userTypeClass.getName());
        }
        catch (IllegalAccessException iae) {
            throw new MappingException("IllegalAccessException trying to instantiate custom type: " + userTypeClass.getName());
        }
        TypeFactory.injectParameters(this.userType, parameters);
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public Type[] getSubtypes() {
        return this.userType.getPropertyTypes();
    }

    public String[] getPropertyNames() {
        return this.userType.getPropertyNames();
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component, session.getEntityMode());
    }

    public Object[] getPropertyValues(Object component, EntityMode entityMode) throws HibernateException {
        int len = this.getSubtypes().length;
        Object[] result = new Object[len];
        int i = 0;
        while (i < len) {
            result[i] = this.getPropertyValue(component, i);
            ++i;
        }
        return result;
    }

    public void setPropertyValues(Object component, Object[] values, EntityMode entityMode) throws HibernateException {
        int i = 0;
        while (i < values.length) {
            this.userType.setPropertyValue(component, i, values[i]);
            ++i;
        }
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return this.userType.getPropertyValue(component, i);
    }

    public CascadeStyle getCascadeStyle(int i) {
        return CascadeStyle.NONE;
    }

    public FetchMode getFetchMode(int i) {
        return FetchMode.DEFAULT;
    }

    public boolean isComponentType() {
        return true;
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return this.userType.deepCopy(value);
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.userType.assemble(cached, session, owner);
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.userType.disassemble(value, session);
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return this.userType.replace(original, target, session, owner);
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode) throws HibernateException {
        return this.userType.equals(x, y);
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        return this.userType.hashCode(x);
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        Type[] types = this.userType.getPropertyTypes();
        int n = 0;
        int i = 0;
        while (i < types.length) {
            n += types[i].getColumnSpan(mapping);
            ++i;
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public Class getReturnedClass() {
        return this.userType.returnedClass();
    }

    public boolean isMutable() {
        return this.userType.isMutable();
    }

    public Object nullSafeGet(ResultSet rs, String columnName, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, new String[]{columnName}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, names, session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.userType.nullSafeSet(st, value, index, session);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        this.userType.nullSafeSet(st, value, index, session);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        Type[] types = this.userType.getPropertyTypes();
        int[] result = new int[this.getColumnSpan(mapping)];
        int n = 0;
        int i = 0;
        while (i < types.length) {
            int[] sqlTypes = types[i].sqlTypes(mapping);
            int k = 0;
            while (k < sqlTypes.length) {
                result[n++] = sqlTypes[k];
                ++k;
            }
            ++i;
        }
        return result;
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    public boolean[] getPropertyNullability() {
        return null;
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return xml;
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        CompositeCustomType.replaceNode(node, (Element)value);
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value == null) {
            return result;
        }
        Object[] values = this.getPropertyValues(value, EntityMode.POJO);
        int loc = 0;
        Type[] propertyTypes = this.getSubtypes();
        int i = 0;
        while (i < propertyTypes.length) {
            boolean[] propertyNullness = propertyTypes[i].toColumnNullness(values[i], mapping);
            System.arraycopy(propertyNullness, 0, result, loc, propertyNullness.length);
            loc += propertyNullness.length;
            ++i;
        }
        return result;
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    public boolean isEmbedded() {
        return false;
    }
}

