/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.HibernateException;
import org.hibernate.type.AbstractCharArrayType;

public class CharacterArrayType
extends AbstractCharArrayType {
    protected Object toExternalFormat(char[] chars) {
        if (chars == null) {
            return null;
        }
        Character[] characters = new Character[chars.length];
        int i = 0;
        while (i < chars.length) {
            characters[i] = new Character(chars[i]);
            ++i;
        }
        return characters;
    }

    protected char[] toInternalFormat(Object value) {
        if (value == null) {
            return null;
        }
        Character[] characters = (Character[])value;
        char[] chars = new char[characters.length];
        int i = 0;
        while (i < characters.length) {
            if (characters[i] == null) {
                throw new HibernateException("Unable to store an Character[] when one of its element is null");
            }
            chars[i] = characters[i].charValue();
            ++i;
        }
        return chars;
    }

    public Class getReturnedClass() {
        return Character[].class;
    }

    public String getName() {
        return "wrapper-characters";
    }
}

