/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;

public abstract class AbstractBynaryType
extends MutableType
implements VersionType,
Comparator {
    protected abstract Object toExternalFormat(byte[] var1);

    protected abstract byte[] toInternalFormat(Object var1);

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        byte[] internalValue = this.toInternalFormat(value);
        if (Environment.useStreamsForBinary()) {
            st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(internalValue), internalValue.length);
        } else {
            st.setBytes(index, internalValue);
        }
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            InputStream inputStream = rs.getBinaryStream(name);
            if (inputStream == null) {
                return this.toExternalFormat(null);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[2048];
            try {
                int amountRead;
                while ((amountRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, amountRead);
                }
                inputStream.close();
                outputStream.close();
            }
            catch (IOException ioe) {
                throw new HibernateException("IOException occurred reading a binary value", ioe);
            }
            return this.toExternalFormat(outputStream.toByteArray());
        }
        return this.toExternalFormat(rs.getBytes(name));
    }

    public int sqlType() {
        return -3;
    }

    public Object seed(SessionImplementor session) {
        return null;
    }

    public Object next(Object current, SessionImplementor session) {
        return current;
    }

    public Comparator getComparator() {
        return this;
    }

    public int compare(Object o1, Object o2) {
        return this.compare(o1, o2, null);
    }

    public boolean isEqual(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals(this.toInternalFormat(x), this.toInternalFormat(y));
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        byte[] bytes = this.toInternalFormat(x);
        int hashCode = 1;
        int j = 0;
        while (j < bytes.length) {
            hashCode = 31 * hashCode + bytes[j];
            ++j;
        }
        return hashCode;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        byte[] ybytes;
        byte[] xbytes = this.toInternalFormat(x);
        if (xbytes.length < (ybytes = this.toInternalFormat(y)).length) {
            return -1;
        }
        if (xbytes.length > ybytes.length) {
            return 1;
        }
        int i = 0;
        while (i < xbytes.length) {
            if (xbytes[i] < ybytes[i]) {
                return -1;
            }
            if (xbytes[i] > ybytes[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public abstract String getName();

    public String toString(Object val) {
        byte[] bytes = this.toInternalFormat(val);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hexStr = Integer.toHexString(bytes[i] - -128);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
            ++i;
        }
        return buf.toString();
    }

    public Object deepCopyNotNull(Object value) {
        byte[] bytes = this.toInternalFormat(value);
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return this.toExternalFormat(result);
    }

    public Object fromStringValue(String xml) throws HibernateException {
        if (xml == null) {
            return null;
        }
        if (xml.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid xml representation of a binary content.");
        }
        byte[] bytes = new byte[xml.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            String hexStr = xml.substring(i * 2, (i + 1) * 2);
            bytes[i] = (byte)(Integer.parseInt(hexStr, 16) + -128);
            ++i;
        }
        return this.toExternalFormat(bytes);
    }
}

