/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.util.ByteCodeHelper;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.bytecode.util.FieldFilter;

public abstract class BasicInstrumentationTask
extends Task {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    protected final Logger logger = new Logger();
    private List filesets = new ArrayList();
    private Set classNames = new HashSet();
    private boolean extended;
    private boolean verbose;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    protected final Iterator filesets() {
        return this.filesets.iterator();
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        if (this.isExtended()) {
            this.collectClassNames();
        }
        this.logger.info("starting instrumentation");
        Project project = this.getProject();
        Iterator filesets = this.filesets();
        while (filesets.hasNext()) {
            FileSet fs = (FileSet)filesets.next();
            DirectoryScanner ds = fs.getDirectoryScanner(project);
            String[] includedFiles = ds.getIncludedFiles();
            File d = fs.getDir(project);
            int i = 0;
            while (i < includedFiles.length) {
                File file = new File(d, includedFiles[i]);
                try {
                    this.processFile(file);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
                ++i;
            }
        }
    }

    private void collectClassNames() {
        this.logger.info("collecting class names for extended instrumentation determination");
        Project project = this.getProject();
        Iterator filesets = this.filesets();
        while (filesets.hasNext()) {
            FileSet fs = (FileSet)filesets.next();
            DirectoryScanner ds = fs.getDirectoryScanner(project);
            String[] includedFiles = ds.getIncludedFiles();
            File d = fs.getDir(project);
            int i = 0;
            while (i < includedFiles.length) {
                File file = new File(d, includedFiles[i]);
                try {
                    this.collectClassNames(file);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
                ++i;
            }
        }
        this.logger.info(String.valueOf(this.classNames.size()) + " class(es) being checked");
    }

    private void collectClassNames(File file) throws Exception {
        if (this.isClassFile(file)) {
            byte[] bytes = ByteCodeHelper.readByteCode(file);
            ClassDescriptor descriptor = this.getClassDescriptor(bytes);
            this.classNames.add(descriptor.getName());
        } else if (this.isJarFile(file)) {
            ZipEntryHandler collector = new ZipEntryHandler(){

                public void handleEntry(ZipEntry entry, byte[] byteCode) throws Exception {
                    DataInputStream din;
                    if (!entry.isDirectory() && (din = new DataInputStream(new ByteArrayInputStream(byteCode))).readInt() == -889275714) {
                        BasicInstrumentationTask.this.classNames.add(BasicInstrumentationTask.this.getClassDescriptor(byteCode).getName());
                    }
                }
            };
            ZipFileProcessor processor = new ZipFileProcessor(collector);
            processor.process(file);
        }
    }

    protected void processFile(File file) throws Exception {
        if (this.isClassFile(file)) {
            this.processClassFile(file);
        } else if (this.isJarFile(file)) {
            this.processJarFile(file);
        } else {
            this.logger.verbose("ignoring " + file.toURL());
        }
    }

    protected final boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    protected final boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }

    protected final boolean checkMagic(File file, long magic) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        try {
            int m = in.readInt();
            boolean bl = magic == (long)m;
            return bl;
        }
        finally {
            in.close();
        }
    }

    protected void processClassFile(File file) throws Exception {
        this.logger.verbose("Starting class file : " + file.toURL());
        byte[] bytes = ByteCodeHelper.readByteCode(file);
        ClassDescriptor descriptor = this.getClassDescriptor(bytes);
        ClassTransformer transformer = this.getClassTransformer(descriptor);
        if (transformer == null) {
            this.logger.verbose("skipping file : " + file.toURL());
            return;
        }
        this.logger.info("processing class [" + descriptor.getName() + "]; file = " + file.toURL());
        byte[] transformedBytes = transformer.transform(((Object)((Object)this)).getClass().getClassLoader(), descriptor.getName(), null, null, descriptor.getBytes());
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(transformedBytes);
            out.flush();
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void processJarFile(final File file) throws Exception {
        block9: {
            this.logger.verbose("starting jar file : " + file.toURL());
            File tempFile = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                FileOutputStream fout = new FileOutputStream(tempFile, false);
                try {
                    final ZipOutputStream out = new ZipOutputStream(fout);
                    ZipEntryHandler transformer = new ZipEntryHandler(){

                        public void handleEntry(ZipEntry entry, byte[] byteCode) throws Exception {
                            BasicInstrumentationTask.this.logger.verbose("starting entry : " + entry.toString());
                            if (!entry.isDirectory()) {
                                DataInputStream din = new DataInputStream(new ByteArrayInputStream(byteCode));
                                if (din.readInt() == -889275714) {
                                    ClassDescriptor descriptor = BasicInstrumentationTask.this.getClassDescriptor(byteCode);
                                    ClassTransformer transformer = BasicInstrumentationTask.this.getClassTransformer(descriptor);
                                    if (transformer == null) {
                                        BasicInstrumentationTask.this.logger.verbose("skipping entry : " + entry.toString());
                                    } else {
                                        BasicInstrumentationTask.this.logger.info("processing class [" + descriptor.getName() + "]; entry = " + file.toURL());
                                        byteCode = transformer.transform(this.getClass().getClassLoader(), descriptor.getName(), null, null, descriptor.getBytes());
                                    }
                                } else {
                                    BasicInstrumentationTask.this.logger.verbose("ignoring zip entry : " + entry.toString());
                                }
                            }
                            ZipEntry outEntry = new ZipEntry(entry.getName());
                            outEntry.setMethod(entry.getMethod());
                            outEntry.setComment(entry.getComment());
                            outEntry.setSize(byteCode.length);
                            if (outEntry.getMethod() == 0) {
                                CRC32 crc = new CRC32();
                                crc.update(byteCode);
                                outEntry.setCrc(crc.getValue());
                                outEntry.setCompressedSize(byteCode.length);
                            }
                            out.putNextEntry(outEntry);
                            out.write(byteCode);
                            out.closeEntry();
                        }
                    };
                    ZipFileProcessor processor = new ZipFileProcessor(transformer);
                    processor.process(file);
                    out.close();
                }
                finally {
                    fout.close();
                }
                if (file.delete()) {
                    File newFile = new File(tempFile.getAbsolutePath());
                    if (!newFile.renameTo(file)) {
                        throw new IOException("can not rename " + tempFile + " to " + file);
                    }
                    break block9;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                tempFile.delete();
            }
        }
    }

    protected boolean isBeingIntrumented(String className) {
        this.logger.verbose("checking to see if class [" + className + "] is set to be instrumented");
        return this.classNames.contains(className);
    }

    protected abstract ClassDescriptor getClassDescriptor(byte[] var1) throws Exception;

    protected abstract ClassTransformer getClassTransformer(ClassDescriptor var1);

    protected class CustomFieldFilter
    implements FieldFilter {
        private final ClassDescriptor descriptor;

        public CustomFieldFilter(ClassDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public boolean shouldInstrumentField(String className, String fieldName) {
            if (this.descriptor.getName().equals(className)) {
                BasicInstrumentationTask.this.logger.verbose("accepting transformation of field [" + className + "." + fieldName + "]");
                return true;
            }
            BasicInstrumentationTask.this.logger.verbose("not accepting transformation of field [" + className + "." + fieldName + "]");
            return false;
        }

        public boolean shouldTransformFieldAccess(String transformingClassName, String fieldOwnerClassName, String fieldName) {
            if (this.descriptor.getName().equals(fieldOwnerClassName)) {
                BasicInstrumentationTask.this.logger.verbose("accepting transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
                return true;
            }
            if (BasicInstrumentationTask.this.isExtended() && BasicInstrumentationTask.this.isBeingIntrumented(fieldOwnerClassName)) {
                BasicInstrumentationTask.this.logger.verbose("accepting extended transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
                return true;
            }
            BasicInstrumentationTask.this.logger.verbose("not accepting transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
            return false;
        }
    }

    protected class Logger {
        protected Logger() {
        }

        public void verbose(String message) {
            if (BasicInstrumentationTask.this.verbose) {
                System.out.println(message);
            } else {
                BasicInstrumentationTask.this.log(message, 3);
            }
        }

        public void debug(String message) {
            BasicInstrumentationTask.this.log(message, 4);
        }

        public void info(String message) {
            BasicInstrumentationTask.this.log(message, 2);
        }

        public void warn(String message) {
            BasicInstrumentationTask.this.log(message, 1);
        }
    }

    private static interface ZipEntryHandler {
        public void handleEntry(ZipEntry var1, byte[] var2) throws Exception;
    }

    private static class ZipFileProcessor {
        private final ZipEntryHandler entryHandler;

        public ZipFileProcessor(ZipEntryHandler entryHandler) {
            this.entryHandler = entryHandler;
        }

        public void process(File file) throws Exception {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    byte[] bytes = ByteCodeHelper.readByteCode(zip);
                    this.entryHandler.handleEntry(entry, bytes);
                    zip.closeEntry();
                }
            }
            finally {
                zip.close();
            }
        }
    }
}

