/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.pretty.DDLFormatter;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaExport {
    private static final Log log = LogFactory.getLog(SchemaExport.class);
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private String importFile = "/import.sql";
    private Dialect dialect;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private boolean haltOnError = false;
    private boolean format = true;

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(Configuration cfg, Settings settings) throws HibernateException {
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.format = settings.isFormatSqlEnabled();
    }

    public SchemaExport(Configuration cfg, Properties properties) throws HibernateException {
        this.dialect = Dialect.getDialect(properties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.format = PropertiesHelper.getBoolean("hibernate.format_sql", props);
    }

    public SchemaExport(Configuration cfg, Connection connection) {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(cfg.getProperties());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setImportFile(String filename) {
        this.importFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.execute(script, export, false, false);
    }

    public void drop(boolean script, boolean export) {
        this.execute(script, export, true, false);
    }

    private String format(String sql) {
        return this.format ? new DDLFormatter(sql).format() : sql;
    }

    public void execute(boolean script, boolean export, boolean justDrop, boolean justCreate) {
        log.info((Object)"Running hbm2ddl schema export");
        Connection connection = null;
        Writer outputFileWriter = null;
        InputStreamReader importFileReader = null;
        Statement statement = null;
        this.exceptions.clear();
        try {
            try {
                try {
                    InputStream stream = ConfigHelper.getResourceAsStream(this.importFile);
                    importFileReader = new InputStreamReader(stream);
                }
                catch (HibernateException e) {
                    log.debug((Object)("import file not found: " + this.importFile));
                }
                if (this.outputFile != null) {
                    log.info((Object)("writing generated schema to file: " + this.outputFile));
                    outputFileWriter = new FileWriter(this.outputFile);
                }
                if (export) {
                    log.info((Object)"exporting generated schema to database");
                    this.connectionHelper.prepare(true);
                    connection = this.connectionHelper.getConnection();
                    statement = connection.createStatement();
                }
                if (!justCreate) {
                    this.drop(script, export, outputFileWriter, statement);
                }
                if (!justDrop) {
                    this.create(script, export, outputFileWriter, statement);
                    if (export && importFileReader != null) {
                        this.importScript(importFileReader, statement);
                    }
                }
                log.info((Object)"schema export complete");
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error((Object)"schema export unsuccessful", (Throwable)e);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionHelper.release();
                    }
                }
                catch (Exception e2) {
                    this.exceptions.add(e2);
                    log.error((Object)"Could not close connection", (Throwable)e2);
                }
                try {
                    if (outputFileWriter != null) {
                        outputFileWriter.close();
                    }
                    if (importFileReader != null) {
                        ((Reader)importFileReader).close();
                    }
                }
                catch (IOException ioe) {
                    this.exceptions.add(ioe);
                    log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.connectionHelper.release();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error((Object)"Could not close connection", (Throwable)e);
            }
            try {
                if (outputFileWriter != null) {
                    outputFileWriter.close();
                }
                if (importFileReader != null) {
                    ((Reader)importFileReader).close();
                }
            }
            catch (IOException ioe) {
                this.exceptions.add(ioe);
                log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
            }
        }
    }

    private void importScript(Reader importFileReader, Statement statement) throws IOException {
        log.info((Object)("Executing import script: " + this.importFile));
        BufferedReader reader = new BufferedReader(importFileReader);
        String sql = reader.readLine();
        while (sql != null) {
            try {
                String trimmedSql = sql.trim();
                if (!(trimmedSql.length() == 0 || trimmedSql.startsWith("--") || trimmedSql.startsWith("//") || trimmedSql.startsWith("/*"))) {
                    if (trimmedSql.endsWith(";")) {
                        trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
                    }
                    log.debug((Object)trimmedSql);
                    statement.execute(trimmedSql);
                }
            }
            catch (SQLException e) {
                throw new JDBCException("Error during import script execution", e);
            }
            sql = reader.readLine();
        }
    }

    private void create(boolean script, boolean export, Writer fileOutput, Statement statement) throws IOException {
        int j = 0;
        while (j < this.createSQL.length) {
            try {
                this.execute(script, export, fileOutput, statement, this.createSQL[j]);
            }
            catch (SQLException e) {
                if (this.haltOnError) {
                    throw new JDBCException("Error during DDL export", e);
                }
                this.exceptions.add(e);
                log.error((Object)("Unsuccessful: " + this.createSQL[j]));
                log.error((Object)e.getMessage());
            }
            ++j;
        }
    }

    private void drop(boolean script, boolean export, Writer fileOutput, Statement statement) throws IOException {
        int i = 0;
        while (i < this.dropSQL.length) {
            try {
                this.execute(script, export, fileOutput, statement, this.dropSQL[i]);
            }
            catch (SQLException e) {
                this.exceptions.add(e);
                log.debug((Object)("Unsuccessful: " + this.dropSQL[i]));
                log.debug((Object)e.getMessage());
            }
            ++i;
        }
    }

    private void execute(boolean script, boolean export, Writer fileOutput, Statement statement, String sql) throws IOException, SQLException {
        String formatted = this.format(sql);
        if (this.delimiter != null) {
            formatted = String.valueOf(formatted) + this.delimiter;
        }
        if (script) {
            System.out.println(formatted);
        }
        log.debug((Object)formatted);
        if (this.outputFile != null) {
            fileOutput.write(String.valueOf(formatted) + "\n");
        }
        if (export) {
            statement.executeUpdate(sql);
            SQLWarning warnings = statement.getWarnings();
            if (warnings != null) {
                JDBCExceptionReporter.logAndClearWarnings(this.connectionHelper.getConnection());
            }
        }
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean drop = false;
            boolean create = false;
            boolean halt = false;
            boolean export = true;
            String outFile = null;
            String importFile = "/import.sql";
            String propFile = null;
            boolean format = false;
            String delim = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                    } else if (args[i].equals("--drop")) {
                        drop = true;
                    } else if (args[i].equals("--create")) {
                        create = true;
                    } else if (args[i].equals("--haltonerror")) {
                        halt = true;
                    } else if (args[i].equals("--text")) {
                        export = false;
                    } else if (args[i].startsWith("--output=")) {
                        outFile = args[i].substring(9);
                    } else if (args[i].startsWith("--import=")) {
                        importFile = args[i].substring(9);
                    } else if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                    } else if (args[i].equals("--format")) {
                        format = true;
                    } else if (args[i].startsWith("--delimiter=")) {
                        delim = args[i].substring(12);
                    } else if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                    } else if (args[i].startsWith("--naming=")) {
                        cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    }
                } else {
                    String filename = args[i];
                    if (filename.endsWith(".jar")) {
                        cfg.addJar(new File(filename));
                    } else {
                        cfg.addFile(filename);
                    }
                }
                ++i;
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            SchemaExport se = new SchemaExport(cfg).setHaltOnError(halt).setOutputFile(outFile).setImportFile(importFile).setDelimiter(delim);
            if (format) {
                se.setFormat(true);
            }
            se.execute(script, export, drop, create);
        }
        catch (Exception e) {
            log.error((Object)"Error creating schema ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public SchemaExport setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public SchemaExport setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
        return this;
    }
}

