/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.util.StringHelper;

public class Delete {
    private String tableName;
    private String[] primaryKeyColumnNames;
    private String versionColumnName;
    private String where;
    private String comment;

    public Delete setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Delete setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String toStatementString() {
        StringBuffer buf = new StringBuffer(this.tableName.length() + 10);
        if (this.comment != null) {
            buf.append("/* ").append(this.comment).append(" */ ");
        }
        buf.append("delete from ").append(this.tableName);
        if (this.where != null || this.primaryKeyColumnNames != null || this.versionColumnName != null) {
            buf.append(" where ");
        }
        boolean conditionsAppended = false;
        if (this.primaryKeyColumnNames != null) {
            buf.append(StringHelper.join("=? and ", this.primaryKeyColumnNames)).append("=?");
            conditionsAppended = true;
        }
        if (this.where != null) {
            if (conditionsAppended) {
                buf.append(" and ");
            }
            buf.append(this.where);
            conditionsAppended = true;
        }
        if (this.versionColumnName != null) {
            if (conditionsAppended) {
                buf.append(" and ");
            }
            buf.append(this.versionColumnName).append("=?");
        }
        return buf.toString();
    }

    public Delete setWhere(String where) {
        this.where = where;
        return this;
    }

    public Delete addWhereFragment(String fragment) {
        this.where = this.where == null ? fragment : String.valueOf(this.where) + " and " + fragment;
        return this;
    }

    public Delete setPrimaryKeyColumnNames(String[] primaryKeyColumnNames) {
        this.primaryKeyColumnNames = primaryKeyColumnNames;
        return this;
    }

    public Delete setVersionColumnName(String versionColumnName) {
        this.versionColumnName = versionColumnName;
        return this;
    }
}

