/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.Mapping;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractPropertyMapping
implements PropertyMapping {
    private final Map typesByPropertyPath = new HashMap();
    private final Map columnsByPropertyPath = new HashMap();
    private final Map formulaTemplatesByPropertyPath = new HashMap();

    public String[] getIdentifierColumnNames() {
        throw new UnsupportedOperationException("one-to-one is not supported here");
    }

    protected abstract String getEntityName();

    public Type toType(String propertyName) throws QueryException {
        Type type = (Type)this.typesByPropertyPath.get(propertyName);
        if (type == null) {
            throw this.propertyException(propertyName);
        }
        return type;
    }

    protected final QueryException propertyException(String propertyName) {
        return new QueryException("could not resolve property: " + propertyName + " of: " + this.getEntityName());
    }

    public String[] getColumnNames(String propertyName) {
        String[] cols = (String[])this.columnsByPropertyPath.get(propertyName);
        if (cols == null) {
            throw new MappingException("unknown property: " + propertyName);
        }
        return cols;
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        String[] columns = (String[])this.columnsByPropertyPath.get(propertyName);
        if (columns == null) {
            throw this.propertyException(propertyName);
        }
        String[] templates = (String[])this.formulaTemplatesByPropertyPath.get(propertyName);
        String[] result = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            result[i] = columns[i] == null ? StringHelper.replace(templates[i], "$PlaceHolder$", alias) : StringHelper.qualify(alias, columns[i]);
            ++i;
        }
        return result;
    }

    public String[] toColumns(String propertyName) throws QueryException {
        String[] columns = (String[])this.columnsByPropertyPath.get(propertyName);
        if (columns == null) {
            throw this.propertyException(propertyName);
        }
        String[] templates = (String[])this.formulaTemplatesByPropertyPath.get(propertyName);
        String[] result = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            result[i] = columns[i] == null ? StringHelper.replace(templates[i], "$PlaceHolder$", "") : columns[i];
            ++i;
        }
        return result;
    }

    protected void addPropertyPath(String path, Type type, String[] columns, String[] formulaTemplates) {
        this.typesByPropertyPath.put(path, type);
        this.columnsByPropertyPath.put(path, columns);
        if (formulaTemplates != null) {
            this.formulaTemplatesByPropertyPath.put(path, formulaTemplates);
        }
    }

    protected void initPropertyPaths(String path, Type type, String[] columns, String[] formulaTemplates, Mapping factory) throws MappingException {
        Type actype;
        if (columns.length != type.getColumnSpan(factory)) {
            throw new MappingException("broken column mapping for: " + path + " of: " + this.getEntityName());
        }
        if (type.isAssociationType()) {
            actype = (AssociationType)type;
            if (actype.useLHSPrimaryKey()) {
                columns = this.getIdentifierColumnNames();
            } else {
                String foreignKeyProperty = actype.getLHSPropertyName();
                if (foreignKeyProperty != null && !path.equals(foreignKeyProperty) && (columns = (String[])this.columnsByPropertyPath.get(foreignKeyProperty)) == null) {
                    return;
                }
            }
        }
        if (path != null) {
            this.addPropertyPath(path, type, columns, formulaTemplates);
        }
        if (type.isComponentType()) {
            actype = (AbstractComponentType)type;
            this.initComponentPropertyPaths(path, (AbstractComponentType)actype, columns, formulaTemplates, factory);
            if (actype.isEmbedded()) {
                this.initComponentPropertyPaths(path == null ? null : StringHelper.qualifier(path), (AbstractComponentType)actype, columns, formulaTemplates, factory);
            }
        } else if (type.isEntityType()) {
            this.initIdentifierPropertyPaths(path, (EntityType)type, columns, factory);
        }
    }

    protected void initIdentifierPropertyPaths(String path, EntityType etype, String[] columns, Mapping factory) throws MappingException {
        Type idtype = etype.getIdentifierOrUniqueKeyType(factory);
        String idPropName = etype.getIdentifierOrUniqueKeyPropertyName(factory);
        boolean hasNonIdentifierPropertyNamedId = this.hasNonIdentifierPropertyNamedId(etype, factory);
        if (etype.isReferenceToPrimaryKey() && !hasNonIdentifierPropertyNamedId) {
            String idpath1 = AbstractPropertyMapping.extendPath(path, "id");
            this.addPropertyPath(idpath1, idtype, columns, null);
            this.initPropertyPaths(idpath1, idtype, columns, null, factory);
        }
        if (idPropName != null) {
            String idpath2 = AbstractPropertyMapping.extendPath(path, idPropName);
            this.addPropertyPath(idpath2, idtype, columns, null);
            this.initPropertyPaths(idpath2, idtype, columns, null, factory);
        }
    }

    private boolean hasNonIdentifierPropertyNamedId(EntityType entityType, Mapping factory) {
        try {
            return factory.getReferencedPropertyType(entityType.getAssociatedEntityName(), "id") != null;
        }
        catch (MappingException e) {
            return false;
        }
    }

    protected void initComponentPropertyPaths(String path, AbstractComponentType type, String[] columns, String[] formulaTemplates, Mapping factory) throws MappingException {
        Type[] types = type.getSubtypes();
        String[] properties = type.getPropertyNames();
        int begin = 0;
        int i = 0;
        while (i < properties.length) {
            String subpath = AbstractPropertyMapping.extendPath(path, properties[i]);
            try {
                int length = types[i].getColumnSpan(factory);
                String[] columnSlice = ArrayHelper.slice(columns, begin, length);
                String[] formulaSlice = formulaTemplates == null ? null : ArrayHelper.slice(formulaTemplates, begin, length);
                this.initPropertyPaths(subpath, types[i], columnSlice, formulaSlice, factory);
                begin += length;
            }
            catch (Exception e) {
                throw new MappingException("bug in initComponentPropertyPaths", e);
            }
            ++i;
        }
    }

    private static String extendPath(String path, String property) {
        if (path == null || "".equals(path)) {
            return property;
        }
        return StringHelper.qualify(path, property);
    }
}

