/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.sql.NativeSQLQueryCollectionReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryNonScalarReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.ColumnEntityAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.custom.CollectionFetchReturn;
import org.hibernate.loader.custom.CollectionReturn;
import org.hibernate.loader.custom.ColumnCollectionAliases;
import org.hibernate.loader.custom.EntityFetchReturn;
import org.hibernate.loader.custom.FetchReturn;
import org.hibernate.loader.custom.NonScalarReturn;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.ScalarReturn;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class SQLQueryReturnProcessor {
    public static final Log log = LogFactory.getLog(SQLQueryReturnProcessor.class);
    private NativeSQLQueryReturn[] queryReturns;
    private final Map alias2Return = new HashMap();
    private final Map alias2OwnerAlias = new HashMap();
    private final Map alias2Persister = new HashMap();
    private final Map alias2Suffix = new HashMap();
    private final Map alias2CollectionPersister = new HashMap();
    private final Map alias2CollectionSuffix = new HashMap();
    private final Map entityPropertyResultMaps = new HashMap();
    private final Map collectionPropertyResultMaps = new HashMap();
    private final SessionFactoryImplementor factory;
    private int entitySuffixSeed = 0;
    private int collectionSuffixSeed = 0;

    public SQLQueryReturnProcessor(NativeSQLQueryReturn[] queryReturns, SessionFactoryImplementor factory) {
        this.queryReturns = queryReturns;
        this.factory = factory;
    }

    private Map internalGetPropertyResultsMap(String alias) {
        NativeSQLQueryReturn rtn = (NativeSQLQueryReturn)this.alias2Return.get(alias);
        if (rtn instanceof NativeSQLQueryNonScalarReturn) {
            return ((NativeSQLQueryNonScalarReturn)rtn).getPropertyResultsMap();
        }
        return null;
    }

    private boolean hasPropertyResultMap(String alias) {
        Map propertyMaps = this.internalGetPropertyResultsMap(alias);
        return propertyMaps != null && !propertyMaps.isEmpty();
    }

    public ResultAliasContext process() {
        int i = 0;
        while (i < this.queryReturns.length) {
            if (this.queryReturns[i] instanceof NativeSQLQueryNonScalarReturn) {
                NativeSQLQueryNonScalarReturn rtn = (NativeSQLQueryNonScalarReturn)this.queryReturns[i];
                this.alias2Return.put(rtn.getAlias(), rtn);
                if (rtn instanceof NativeSQLQueryJoinReturn) {
                    NativeSQLQueryJoinReturn fetchReturn = (NativeSQLQueryJoinReturn)rtn;
                    this.alias2OwnerAlias.put(fetchReturn.getAlias(), fetchReturn.getOwnerAlias());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.queryReturns.length) {
            this.processReturn(this.queryReturns[i]);
            ++i;
        }
        return new ResultAliasContext();
    }

    public List generateCustomReturns(boolean queryHadAliases) {
        ArrayList<Return> customReturns = new ArrayList<Return>();
        HashMap<String, NonScalarReturn> customReturnsByAlias = new HashMap<String, NonScalarReturn>();
        int i = 0;
        while (i < this.queryReturns.length) {
            String alias;
            NativeSQLQueryReturn rtn;
            if (this.queryReturns[i] instanceof NativeSQLQueryScalarReturn) {
                rtn = (NativeSQLQueryScalarReturn)this.queryReturns[i];
                customReturns.add(new ScalarReturn(((NativeSQLQueryScalarReturn)rtn).getType(), ((NativeSQLQueryScalarReturn)rtn).getColumnAlias()));
            } else if (this.queryReturns[i] instanceof NativeSQLQueryRootReturn) {
                rtn = (NativeSQLQueryRootReturn)this.queryReturns[i];
                alias = ((NativeSQLQueryNonScalarReturn)rtn).getAlias();
                DefaultEntityAliases entityAliases = queryHadAliases || this.hasPropertyResultMap(alias) ? new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias)) : new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias));
                RootReturn customReturn = new RootReturn(alias, ((NativeSQLQueryRootReturn)rtn).getReturnEntityName(), entityAliases, ((NativeSQLQueryNonScalarReturn)rtn).getLockMode());
                customReturns.add(customReturn);
                customReturnsByAlias.put(((NativeSQLQueryNonScalarReturn)rtn).getAlias(), customReturn);
            } else if (this.queryReturns[i] instanceof NativeSQLQueryCollectionReturn) {
                CollectionAliases collectionAliases;
                rtn = (NativeSQLQueryCollectionReturn)this.queryReturns[i];
                alias = ((NativeSQLQueryNonScalarReturn)rtn).getAlias();
                SQLLoadableCollection persister = (SQLLoadableCollection)this.alias2CollectionPersister.get(alias);
                boolean isEntityElements = persister.getElementType().isEntityType();
                DefaultEntityAliases elementEntityAliases = null;
                if (queryHadAliases || this.hasPropertyResultMap(alias)) {
                    collectionAliases = new GeneratedCollectionAliases((Map)this.collectionPropertyResultMaps.get(alias), (SQLLoadableCollection)this.alias2CollectionPersister.get(alias), (String)this.alias2CollectionSuffix.get(alias));
                    if (isEntityElements) {
                        elementEntityAliases = new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias));
                    }
                } else {
                    collectionAliases = new ColumnCollectionAliases((Map)this.collectionPropertyResultMaps.get(alias), (SQLLoadableCollection)this.alias2CollectionPersister.get(alias));
                    if (isEntityElements) {
                        elementEntityAliases = new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias));
                    }
                }
                CollectionReturn customReturn = new CollectionReturn(alias, ((NativeSQLQueryCollectionReturn)rtn).getOwnerEntityName(), ((NativeSQLQueryCollectionReturn)rtn).getOwnerProperty(), collectionAliases, elementEntityAliases, ((NativeSQLQueryNonScalarReturn)rtn).getLockMode());
                customReturns.add(customReturn);
                customReturnsByAlias.put(((NativeSQLQueryNonScalarReturn)rtn).getAlias(), customReturn);
            } else if (this.queryReturns[i] instanceof NativeSQLQueryJoinReturn) {
                FetchReturn customReturn;
                rtn = (NativeSQLQueryJoinReturn)this.queryReturns[i];
                alias = ((NativeSQLQueryNonScalarReturn)rtn).getAlias();
                NonScalarReturn ownerCustomReturn = (NonScalarReturn)customReturnsByAlias.get(((NativeSQLQueryJoinReturn)rtn).getOwnerAlias());
                if (this.alias2CollectionPersister.containsKey(alias)) {
                    CollectionAliases collectionAliases;
                    SQLLoadableCollection persister = (SQLLoadableCollection)this.alias2CollectionPersister.get(alias);
                    boolean isEntityElements = persister.getElementType().isEntityType();
                    DefaultEntityAliases elementEntityAliases = null;
                    if (queryHadAliases || this.hasPropertyResultMap(alias)) {
                        collectionAliases = new GeneratedCollectionAliases((Map)this.collectionPropertyResultMaps.get(alias), persister, (String)this.alias2CollectionSuffix.get(alias));
                        if (isEntityElements) {
                            elementEntityAliases = new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias));
                        }
                    } else {
                        collectionAliases = new ColumnCollectionAliases((Map)this.collectionPropertyResultMaps.get(alias), persister);
                        if (isEntityElements) {
                            elementEntityAliases = new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias));
                        }
                    }
                    customReturn = new CollectionFetchReturn(alias, ownerCustomReturn, ((NativeSQLQueryJoinReturn)rtn).getOwnerProperty(), collectionAliases, elementEntityAliases, ((NativeSQLQueryNonScalarReturn)rtn).getLockMode());
                } else {
                    DefaultEntityAliases entityAliases = queryHadAliases || this.hasPropertyResultMap(alias) ? new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias)) : new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(alias), (SQLLoadable)this.alias2Persister.get(alias), (String)this.alias2Suffix.get(alias));
                    customReturn = new EntityFetchReturn(alias, entityAliases, ownerCustomReturn, ((NativeSQLQueryJoinReturn)rtn).getOwnerProperty(), ((NativeSQLQueryNonScalarReturn)rtn).getLockMode());
                }
                customReturns.add(customReturn);
                customReturnsByAlias.put(alias, customReturn);
            }
            ++i;
        }
        return customReturns;
    }

    private SQLLoadable getSQLLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + entityName);
        }
        return (SQLLoadable)persister;
    }

    private String generateEntitySuffix() {
        return BasicLoader.generateSuffixes(this.entitySuffixSeed++, 1)[0];
    }

    private String generateCollectionSuffix() {
        return String.valueOf(this.collectionSuffixSeed++) + "__";
    }

    private void processReturn(NativeSQLQueryReturn rtn) {
        if (rtn instanceof NativeSQLQueryScalarReturn) {
            this.processScalarReturn((NativeSQLQueryScalarReturn)rtn);
        } else if (rtn instanceof NativeSQLQueryRootReturn) {
            this.processRootReturn((NativeSQLQueryRootReturn)rtn);
        } else if (rtn instanceof NativeSQLQueryCollectionReturn) {
            this.processCollectionReturn((NativeSQLQueryCollectionReturn)rtn);
        } else {
            this.processJoinReturn((NativeSQLQueryJoinReturn)rtn);
        }
    }

    private void processScalarReturn(NativeSQLQueryScalarReturn typeReturn) {
    }

    private void processRootReturn(NativeSQLQueryRootReturn rootReturn) {
        if (this.alias2Persister.containsKey(rootReturn.getAlias())) {
            return;
        }
        SQLLoadable persister = this.getSQLLoadable(rootReturn.getReturnEntityName());
        this.addPersister(rootReturn.getAlias(), rootReturn.getPropertyResultsMap(), persister);
    }

    private void addPersister(String alias, Map propertyResult, SQLLoadable persister) {
        this.alias2Persister.put(alias, persister);
        String suffix = this.generateEntitySuffix();
        log.trace((Object)("mapping alias [" + alias + "] to entity-suffix [" + suffix + "]"));
        this.alias2Suffix.put(alias, suffix);
        this.entityPropertyResultMaps.put(alias, propertyResult);
    }

    private void addCollection(String role, String alias, Map propertyResults) {
        SQLLoadableCollection collectionPersister = (SQLLoadableCollection)this.factory.getCollectionPersister(role);
        this.alias2CollectionPersister.put(alias, collectionPersister);
        String suffix = this.generateCollectionSuffix();
        log.trace((Object)("mapping alias [" + alias + "] to collection-suffix [" + suffix + "]"));
        this.alias2CollectionSuffix.put(alias, suffix);
        this.collectionPropertyResultMaps.put(alias, propertyResults);
        if (collectionPersister.isOneToMany()) {
            SQLLoadable persister = (SQLLoadable)collectionPersister.getElementPersister();
            this.addPersister(alias, this.filter(propertyResults), persister);
        }
    }

    private Map filter(Map propertyResults) {
        HashMap result = new HashMap(propertyResults.size());
        String keyPrefix = "element.";
        for (Map.Entry element : propertyResults.entrySet()) {
            String path = (String)element.getKey();
            if (!path.startsWith(keyPrefix)) continue;
            result.put(path.substring(keyPrefix.length()), element.getValue());
        }
        return result;
    }

    private void processCollectionReturn(NativeSQLQueryCollectionReturn collectionReturn) {
        String role = String.valueOf(collectionReturn.getOwnerEntityName()) + '.' + collectionReturn.getOwnerProperty();
        this.addCollection(role, collectionReturn.getAlias(), collectionReturn.getPropertyResultsMap());
    }

    private void processJoinReturn(NativeSQLQueryJoinReturn fetchReturn) {
        SQLLoadable ownerPersister;
        Type returnType;
        String alias = fetchReturn.getAlias();
        if (this.alias2Persister.containsKey(alias) || this.alias2CollectionPersister.containsKey(alias)) {
            return;
        }
        String ownerAlias = fetchReturn.getOwnerAlias();
        if (!this.alias2Return.containsKey(ownerAlias)) {
            throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + alias + "]");
        }
        if (!this.alias2Persister.containsKey(ownerAlias)) {
            NativeSQLQueryNonScalarReturn ownerReturn = (NativeSQLQueryNonScalarReturn)this.alias2Return.get(ownerAlias);
            this.processReturn(ownerReturn);
        }
        if ((returnType = (ownerPersister = (SQLLoadable)this.alias2Persister.get(ownerAlias)).getPropertyType(fetchReturn.getOwnerProperty())).isCollectionType()) {
            String role = String.valueOf(ownerPersister.getEntityName()) + '.' + fetchReturn.getOwnerProperty();
            this.addCollection(role, alias, fetchReturn.getPropertyResultsMap());
        } else if (returnType.isEntityType()) {
            EntityType eType = (EntityType)returnType;
            String returnEntityName = eType.getAssociatedEntityName();
            SQLLoadable persister = this.getSQLLoadable(returnEntityName);
            this.addPersister(alias, fetchReturn.getPropertyResultsMap(), persister);
        }
    }

    class ResultAliasContext {
        ResultAliasContext() {
        }

        public SQLLoadable getEntityPersister(String alias) {
            return (SQLLoadable)SQLQueryReturnProcessor.this.alias2Persister.get(alias);
        }

        public SQLLoadableCollection getCollectionPersister(String alias) {
            return (SQLLoadableCollection)SQLQueryReturnProcessor.this.alias2CollectionPersister.get(alias);
        }

        public String getEntitySuffix(String alias) {
            return (String)SQLQueryReturnProcessor.this.alias2Suffix.get(alias);
        }

        public String getCollectionSuffix(String alias) {
            return (String)SQLQueryReturnProcessor.this.alias2CollectionSuffix.get(alias);
        }

        public String getOwnerAlias(String alias) {
            return (String)SQLQueryReturnProcessor.this.alias2OwnerAlias.get(alias);
        }

        public Map getPropertyResultsMap(String alias) {
            return SQLQueryReturnProcessor.this.internalGetPropertyResultsMap(alias);
        }
    }
}

