/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.intercept;

import java.util.Set;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.intercept.cglib.CGLIBHelper;
import org.hibernate.intercept.javassist.JavassistHelper;

public class FieldInterceptionHelper {
    private FieldInterceptionHelper() {
    }

    public static boolean isInstrumented(Class entityClass) {
        Class<?>[] definedInterfaces = entityClass.getInterfaces();
        int i = 0;
        while (i < definedInterfaces.length) {
            if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(definedInterfaces[i].getName()) || "org.hibernate.bytecode.javassist.FieldHandled".equals(definedInterfaces[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isInstrumented(Object entity) {
        return entity != null && FieldInterceptionHelper.isInstrumented(entity.getClass());
    }

    public static FieldInterceptor extractFieldInterceptor(Object entity) {
        if (entity == null) {
            return null;
        }
        Class<?>[] definedInterfaces = entity.getClass().getInterfaces();
        int i = 0;
        while (i < definedInterfaces.length) {
            if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(definedInterfaces[i].getName())) {
                return CGLIBHelper.extractFieldInterceptor(entity);
            }
            if ("org.hibernate.bytecode.javassist.FieldHandled".equals(definedInterfaces[i].getName())) {
                return JavassistHelper.extractFieldInterceptor(entity);
            }
            ++i;
        }
        return null;
    }

    public static FieldInterceptor injectFieldInterceptor(Object entity, String entityName, Set uninitializedFieldNames, SessionImplementor session) {
        if (entity != null) {
            Class<?>[] definedInterfaces = entity.getClass().getInterfaces();
            int i = 0;
            while (i < definedInterfaces.length) {
                if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(definedInterfaces[i].getName())) {
                    return CGLIBHelper.injectFieldInterceptor(entity, entityName, uninitializedFieldNames, session);
                }
                if ("org.hibernate.bytecode.javassist.FieldHandled".equals(definedInterfaces[i].getName())) {
                    return JavassistHelper.injectFieldInterceptor(entity, entityName, uninitializedFieldNames, session);
                }
                ++i;
            }
        }
        return null;
    }

    public static void clearDirty(Object entity) {
        FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
        if (interceptor != null) {
            interceptor.clearDirty();
        }
    }

    public static void markDirty(Object entity) {
        FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
        if (interceptor != null) {
            interceptor.dirty();
        }
    }
}

